/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import java.io.IOException;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.TemplateOutput;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.TemplateBlockStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapIfPrimitiveStrategy<B extends TemplateBlock>
extends TemplateBlockStrategy<B> {
    private TypeMirror type;

    @Override
    public boolean preProcess(B block, TemplateOutput<B> output, TemplateModel model) throws IOException, TemplateException {
        super.preProcess(block, output, model);
        if (this.type == null) {
            throw new MissingParameterException("type");
        }
        if (this.type instanceof PrimitiveType) {
            String pre;
            switch (((PrimitiveType)this.type).getKind()) {
                case BOOLEAN: {
                    pre = "new Boolean(";
                    break;
                }
                case BYTE: {
                    pre = "new Byte(";
                    break;
                }
                case CHAR: {
                    pre = "new Character(";
                    break;
                }
                case DOUBLE: {
                    pre = "new Double(";
                    break;
                }
                case FLOAT: {
                    pre = "new Float(";
                    break;
                }
                case INT: {
                    pre = "new Integer(";
                    break;
                }
                case LONG: {
                    pre = "new Long(";
                    break;
                }
                case SHORT: {
                    pre = "new Short(";
                    break;
                }
                default: {
                    pre = "";
                }
            }
            output.write(pre);
        }
        return true;
    }

    @Override
    public void postProcess(B block, TemplateOutput<B> output, TemplateModel model) throws IOException, TemplateException {
        super.postProcess(block, output, model);
        if (this.type instanceof PrimitiveType) {
            output.write(")");
        }
    }

    public TypeMirror getType() {
        return this.type;
    }

    public void setType(TypeMirror type) {
        this.type = type;
    }
}

