/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.strategies.AnnotationFilterableDeclarationLoopStrategy;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.PackageDeclarationLoopStrategy;
import net.sf.jelly.apt.strategies.StrategyStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclarationLoopStrategy<B extends TemplateBlock>
extends AnnotationFilterableDeclarationLoopStrategy<TypeDeclaration, B> {
    private PackageDeclaration pckg;
    private boolean includeClasses = true;
    private boolean includeInterfaces = false;

    @Override
    public Collection<TypeDeclaration> getAllDeclarationsToConsiderForAnnotationFiltering() throws MissingParameterException {
        Collection<TypeDeclaration> allTypeDeclarations = this.getAllTypeDeclarations();
        if (this.includeClasses && this.includeInterfaces) {
            return allTypeDeclarations;
        }
        ArrayList<TypeDeclaration> typeDeclarations = new ArrayList<TypeDeclaration>();
        for (TypeDeclaration declaration : allTypeDeclarations) {
            if ((!this.includeClasses || !(declaration instanceof ClassDeclaration)) && (!this.includeInterfaces || !(declaration instanceof InterfaceDeclaration))) continue;
            typeDeclarations.add(declaration);
        }
        return typeDeclarations;
    }

    protected Collection<TypeDeclaration> getAllTypeDeclarations() throws MissingParameterException {
        PackageDeclaration pckg = this.getPackage();
        if (pckg == null) {
            pckg = this.getCurrentPackageDeclaration();
        }
        if (pckg != null) {
            ArrayList<TypeDeclaration> typeDeclarations = new ArrayList<TypeDeclaration>(pckg.getClasses());
            typeDeclarations.addAll(pckg.getInterfaces());
            return typeDeclarations;
        }
        return this.getAnnotationProcessorEnvironment().getTypeDeclarations();
    }

    protected AnnotationProcessorEnvironment getAnnotationProcessorEnvironment() {
        return Context.getCurrentEnvironment();
    }

    public boolean isIncludeInterfaces() {
        return this.includeInterfaces;
    }

    public void setIncludeInterfaces(boolean includeInterfaces) {
        this.includeInterfaces = includeInterfaces;
    }

    public boolean isIncludeClasses() {
        return this.includeClasses;
    }

    public void setIncludeClasses(boolean includeClasses) {
        this.includeClasses = includeClasses;
    }

    public PackageDeclaration getPackage() {
        return this.pckg;
    }

    public void setPackage(PackageDeclaration pckg) {
        this.pckg = pckg;
    }

    @Override
    public TypeDeclaration getCurrentDeclaration() {
        return (TypeDeclaration)super.getCurrentDeclaration();
    }

    protected PackageDeclaration getCurrentPackageDeclaration() {
        PackageDeclarationLoopStrategy loop = StrategyStack.get().findFirst(PackageDeclarationLoopStrategy.class);
        if (loop != null) {
            return (PackageDeclaration)loop.getCurrentDeclaration();
        }
        return null;
    }
}

