/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.Declarations;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.decorations.declaration.DecoratedDeclaration;
import net.sf.jelly.apt.strategies.AnnotationFilterableDeclarationLoopStrategy;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.StrategyStack;
import net.sf.jelly.apt.strategies.TypeDeclarationLoopStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemberDeclarationLoopStrategy<M extends MemberDeclaration, B extends TemplateBlock>
extends AnnotationFilterableDeclarationLoopStrategy<M, B> {
    private boolean includeSuperclasses = false;
    private boolean includeSuperinterfaces = false;
    private TypeDeclaration declaration;

    @Override
    public Collection<M> getAllDeclarationsToConsiderForAnnotationFiltering() throws MissingParameterException {
        ArrayList<Object> allDeclarations = new ArrayList<Object>();
        TypeDeclaration typeDeclaration = this.getDeclaration();
        if (typeDeclaration == null && (typeDeclaration = this.getCurrentTypeDeclaration()) == null) {
            throw new MissingParameterException("declaration");
        }
        allDeclarations.addAll(this.getMemberDeclarations(typeDeclaration));
        if (this.includeSuperclasses && typeDeclaration instanceof ClassDeclaration) {
            Collection<M> superclassDeclarations = this.getSuperclassesMemberDeclarations((ClassDeclaration)typeDeclaration);
            for (MemberDeclaration declaration : superclassDeclarations) {
                if (this.hidden(declaration, allDeclarations)) continue;
                allDeclarations.add(declaration);
            }
        }
        if (this.includeSuperinterfaces) {
            Collection<M> superinterfaceDeclarations = this.getSuperinterfacesMemberDeclarations(typeDeclaration);
            for (MemberDeclaration declaration : superinterfaceDeclarations) {
                if (this.hidden(declaration, allDeclarations)) continue;
                allDeclarations.add(declaration);
            }
        }
        return allDeclarations;
    }

    protected boolean hidden(M declaration, ArrayList<M> declarations) {
        if (declaration instanceof DecoratedDeclaration) {
            declaration = (MemberDeclaration)((DecoratedDeclaration)declaration).getDelegate();
        }
        boolean hides = false;
        Declarations declarationUtils = this.getAnnotationProcessorEnvironment().getDeclarationUtils();
        for (MemberDeclaration sub : declarations) {
            if (sub instanceof DecoratedDeclaration) {
                sub = (MemberDeclaration)((DecoratedDeclaration)sub).getDelegate();
            }
            hides |= declarationUtils.hides(sub, declaration);
            if (!(declaration instanceof MethodDeclaration) || !(sub instanceof MethodDeclaration)) continue;
            hides |= declarationUtils.overrides((MethodDeclaration)sub, (MethodDeclaration)declaration);
        }
        return hides;
    }

    protected AnnotationProcessorEnvironment getAnnotationProcessorEnvironment() {
        return Context.getCurrentEnvironment();
    }

    protected Collection<M> getSuperclassesMemberDeclarations(ClassDeclaration type) throws MissingParameterException {
        ClassDeclaration declaration;
        ArrayList<M> declarations = new ArrayList<M>();
        ClassType superclass = type.getSuperclass();
        if (superclass != null && (declaration = superclass.getDeclaration()) != null) {
            declarations.addAll(this.getMemberDeclarations((TypeDeclaration)declaration));
            declarations.addAll(this.getSuperclassesMemberDeclarations(declaration));
        }
        return declarations;
    }

    protected Collection<M> getSuperinterfacesMemberDeclarations(TypeDeclaration type) throws MissingParameterException {
        ArrayList<M> declarations = new ArrayList<M>();
        Collection superinterfaces = type.getSuperinterfaces();
        for (InterfaceType superinterface : superinterfaces) {
            InterfaceDeclaration declaration = superinterface.getDeclaration();
            if (declaration == null) continue;
            declarations.addAll(this.getMemberDeclarations((TypeDeclaration)declaration));
            declarations.addAll(this.getSuperinterfacesMemberDeclarations((TypeDeclaration)declaration));
        }
        return declarations;
    }

    protected abstract Collection<M> getMemberDeclarations(TypeDeclaration var1) throws MissingParameterException;

    public boolean isIncludeSuperclasses() {
        return this.includeSuperclasses;
    }

    public void setIncludeSuperclasses(boolean includeSuperclasses) {
        this.includeSuperclasses = includeSuperclasses;
    }

    public boolean isIncludeSuperinterfaces() {
        return this.includeSuperinterfaces;
    }

    public void setIncludeSuperinterfaces(boolean includeSuperinterfaces) {
        this.includeSuperinterfaces = includeSuperinterfaces;
    }

    public TypeDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(TypeDeclaration declaration) {
        this.declaration = declaration;
    }

    protected TypeDeclaration getCurrentTypeDeclaration() {
        TypeDeclarationLoopStrategy loop = StrategyStack.get().findFirst(TypeDeclarationLoopStrategy.class);
        if (loop != null) {
            return loop.getCurrentDeclaration();
        }
        return null;
    }
}

