/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.util.SimpleTypeVisitor;
import com.sun.mirror.util.TypeVisitor;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.StrategyStack;
import net.sf.jelly.apt.strategies.TypeDeclarationLoopStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportedTypeDeclarationLoopStrategy<B extends TemplateBlock>
extends TypeDeclarationLoopStrategy<B> {
    private TypeDeclaration declaration;

    public ImportedTypeDeclarationLoopStrategy() {
        this.setIncludeClasses(true);
        this.setIncludeInterfaces(true);
    }

    @Override
    protected Collection<TypeDeclaration> getAllTypeDeclarations() throws MissingParameterException {
        TypeDeclaration declaration = this.getDeclaration();
        if (declaration == null && (declaration = this.getCurrentTypeDeclaration()) == null) {
            throw new MissingParameterException("declaration");
        }
        return ImportedTypeDeclarationLoopStrategy.getAllImportedTypes(declaration);
    }

    public static Collection<TypeDeclaration> getAllImportedTypes(TypeDeclaration typeDeclaration) {
        Collection bounds;
        final HashMap importedTypes = new HashMap();
        SimpleTypeVisitor visitor = new SimpleTypeVisitor(){

            public void visitDeclaredType(DeclaredType declaredType) {
                String qualifiedName;
                TypeDeclaration declaration = declaredType.getDeclaration();
                if (declaration != null && !(qualifiedName = declaration.getQualifiedName()).startsWith("java.lang")) {
                    importedTypes.put(qualifiedName, declaration);
                }
                for (TypeMirror type : declaredType.getActualTypeArguments()) {
                    type.accept((TypeVisitor)this);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getComponentType().accept((TypeVisitor)this);
            }

            public void visitTypeVariable(TypeVariable typeVariable) {
                TypeParameterDeclaration declaration = typeVariable.getDeclaration();
                if (declaration != null) {
                    Collection bounds = declaration.getBounds();
                    for (ReferenceType referenceType : bounds) {
                        referenceType.accept((TypeVisitor)this);
                    }
                }
            }
        };
        for (FieldDeclaration field : typeDeclaration.getFields()) {
            field.getType().accept((TypeVisitor)visitor);
        }
        for (MethodDeclaration method : typeDeclaration.getMethods()) {
            method.getReturnType().accept((TypeVisitor)visitor);
            for (ParameterDeclaration parameter : method.getParameters()) {
                parameter.getType().accept((TypeVisitor)visitor);
            }
            for (ReferenceType thrownType : method.getThrownTypes()) {
                thrownType.accept((TypeVisitor)visitor);
            }
            for (TypeParameterDeclaration formalTypeParameter : method.getFormalTypeParameters()) {
                bounds = formalTypeParameter.getBounds();
                for (ReferenceType bound : bounds) {
                    bound.accept((TypeVisitor)visitor);
                }
            }
        }
        for (InterfaceType interfaceType : typeDeclaration.getSuperinterfaces()) {
            interfaceType.accept((TypeVisitor)visitor);
        }
        if (typeDeclaration instanceof ClassDeclaration) {
            ((ClassDeclaration)typeDeclaration).getSuperclass().accept((TypeVisitor)visitor);
            for (ConstructorDeclaration constructor : ((ClassDeclaration)typeDeclaration).getConstructors()) {
                for (ParameterDeclaration parameter : constructor.getParameters()) {
                    parameter.getType().accept((TypeVisitor)visitor);
                }
                for (ReferenceType thrownType : constructor.getThrownTypes()) {
                    thrownType.accept((TypeVisitor)visitor);
                }
                for (TypeParameterDeclaration formalTypeParameter : constructor.getFormalTypeParameters()) {
                    bounds = formalTypeParameter.getBounds();
                    for (ReferenceType bound : bounds) {
                        bound.accept((TypeVisitor)visitor);
                    }
                }
            }
        }
        for (TypeParameterDeclaration formalTypeParameter : typeDeclaration.getFormalTypeParameters()) {
            Collection bounds2 = formalTypeParameter.getBounds();
            for (ReferenceType bound : bounds2) {
                bound.accept((TypeVisitor)visitor);
            }
        }
        return importedTypes.values();
    }

    public TypeDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(TypeDeclaration declaration) {
        this.declaration = declaration;
    }

    protected TypeDeclaration getCurrentTypeDeclaration() {
        TypeDeclarationLoopStrategy loop = StrategyStack.get().findFirst(TypeDeclarationLoopStrategy.class);
        if (loop != null) {
            return loop.getCurrentDeclaration();
        }
        return null;
    }
}

