/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import java.io.IOException;
import java.util.Collection;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.TemplateOutput;
import net.sf.jelly.apt.strategies.DeclarationLoopStrategy;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.StrategyStack;
import net.sf.jelly.apt.strategies.TemplateBlockStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfHasAnnotationStrategy<B extends TemplateBlock>
extends TemplateBlockStrategy<B> {
    private Declaration declaration;
    private String annotation;
    private String var;

    @Override
    public boolean preProcess(B block, TemplateOutput<B> output, TemplateModel model) throws IOException, TemplateException {
        super.preProcess(block, output, model);
        if (this.annotation == null) {
            throw new MissingParameterException("annotation");
        }
        Declaration declaration = this.getDeclaration();
        if (declaration == null && (declaration = this.getCurrentDeclaration()) == null) {
            throw new MissingParameterException("declaration");
        }
        Collection annotations = declaration.getAnnotationMirrors();
        for (AnnotationMirror mirror : annotations) {
            AnnotationTypeDeclaration annotationDeclaration = mirror.getAnnotationType().getDeclaration();
            if (annotationDeclaration == null || !annotationDeclaration.getQualifiedName().equals(this.annotation)) continue;
            if (this.var != null) {
                model.setVariable(this.var, mirror);
            }
            return true;
        }
        return false;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(Declaration declaration) {
        this.declaration = declaration;
    }

    protected Declaration getCurrentDeclaration() {
        DeclarationLoopStrategy loop = StrategyStack.get().findFirst(DeclarationLoopStrategy.class);
        if (loop != null) {
            return loop.getCurrentDeclaration();
        }
        return null;
    }
}

