/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDeclaration
extends DecoratedMethodDeclaration {
    private final DecoratedMethodDeclaration setter;
    private final DecoratedMethodDeclaration getter;

    public PropertyDeclaration(DecoratedMethodDeclaration getter, DecoratedMethodDeclaration setter) {
        super(getter);
        Collection<ParameterDeclaration> parameters;
        TypeMirror propertyType = this.getReturnType();
        this.getter = getter;
        this.setter = setter;
        if (!(setter == null || (parameters = setter.getParameters()) != null && parameters.size() == 1 && propertyType.equals(parameters.iterator().next().getType()))) {
            throw new IllegalStateException(this.setter.getPosition() + ": invalid setter for " + propertyType);
        }
    }

    public TypeMirror getPropertyType() {
        return this.getReturnType();
    }

    @Override
    public String getSimpleName() {
        return this.getter.getPropertyName();
    }

    @Override
    public String getPropertyName() {
        return this.getter.getPropertyName();
    }

    public DecoratedMethodDeclaration getSetter() {
        return this.setter;
    }

    public DecoratedMethodDeclaration getGetter() {
        return this.getter;
    }

    public boolean isReadOnly() {
        return this.getSetter() == null;
    }

    @Override
    public Map<String, AnnotationMirror> getAnnotations() {
        HashMap<String, AnnotationMirror> annotations = new HashMap<String, AnnotationMirror>();
        if (!this.isReadOnly()) {
            annotations.putAll(this.getSetter().getAnnotations());
        }
        annotations.putAll(this.getGetter().getAnnotations());
        return annotations;
    }

    @Override
    public Collection<AnnotationMirror> getAnnotationMirrors() {
        return this.getAnnotations().values();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A annotation = super.getAnnotation(annotationType);
        if (annotation == null && this.setter != null) {
            annotation = this.setter.getAnnotation(annotationType);
        }
        return annotation;
    }
}

