/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.util.SourcePosition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratedAnnotationMirror
extends HashMap<String, Object>
implements AnnotationMirror {
    private AnnotationMirror delegate;
    private final HashMap<String, Object> allElementValues;

    public DecoratedAnnotationMirror(AnnotationMirror delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("A delegate must be provided.");
        }
        this.delegate = delegate;
        AnnotationType annotationType = delegate.getAnnotationType();
        Collection allElements = annotationType.getDeclaration().getMethods();
        Map<AnnotationTypeElementDeclaration, AnnotationValue> elementValues = this.getElementValues();
        this.put("annotationType", annotationType);
        this.put("position", delegate.getPosition());
        this.put("elementValues", elementValues);
        this.allElementValues = new HashMap();
        for (AnnotationTypeElementDeclaration element : allElements) {
            if (elementValues.containsKey(element)) {
                Object value = elementValues.get(element).getValue();
                this.allElementValues.put(element.getSimpleName(), value);
                this.put(element.getSimpleName(), value);
                continue;
            }
            AnnotationValue defaultValue = element.getDefaultValue();
            if (defaultValue == null) {
                throw new IllegalStateException(delegate.getPosition() + ": the element '" + element.getSimpleName() + "' must have a value specified.");
            }
            Object value = defaultValue.getValue();
            this.allElementValues.put(element.getSimpleName(), value);
            this.put(element.getSimpleName(), value);
        }
    }

    public AnnotationType getAnnotationType() {
        return this.delegate.getAnnotationType();
    }

    public SourcePosition getPosition() {
        return this.delegate.getPosition();
    }

    public Map<AnnotationTypeElementDeclaration, AnnotationValue> getElementValues() {
        return Collections.unmodifiableMap(this.delegate.getElementValues());
    }

    public Map<String, Object> getAllElementValues() {
        return this.allElementValues;
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }
}

