/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDoc
extends HashMap<String, JavaDocTagList> {
    private String value;

    public JavaDoc() {
        this((String)null);
    }

    public JavaDoc(String docComment) {
        if (docComment == null) {
            this.value = "";
        } else {
            BufferedReader reader = new BufferedReader(new StringReader(docComment));
            StringWriter currentValue = new StringWriter();
            PrintWriter out = new PrintWriter(currentValue);
            String currentTag = null;
            try {
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).startsWith("@")) {
                        this.pushValue(currentTag, currentValue.toString());
                        int spaceIndex = line.indexOf(32);
                        if (spaceIndex == -1) {
                            spaceIndex = line.length();
                        }
                        currentTag = line.substring(1, spaceIndex);
                        String value = "";
                        if (spaceIndex + 1 < line.length()) {
                            value = line.substring(spaceIndex + 1);
                        }
                        currentValue = new StringWriter();
                        out = new PrintWriter(currentValue);
                        out.println(value);
                    } else {
                        out.println(line);
                    }
                    line = reader.readLine();
                }
                this.pushValue(currentTag, currentValue.toString());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void pushValue(String tag, String value) {
        value = value.trim();
        if (tag == null) {
            this.value = value;
        } else {
            JavaDocTagList tagList = (JavaDocTagList)this.get(tag);
            if (tagList == null) {
                tagList = new JavaDocTagList(value);
                this.put(tag, tagList);
            } else {
                tagList.add(value);
            }
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaDocTagList
    extends ArrayList<String> {
        public JavaDocTagList(String firstValue) {
            this.add(firstValue);
        }

        @Override
        public String toString() {
            return (String)this.get(0);
        }
    }
}

