/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import com.sun.jini.logging.Levels;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.io.MarshalInputStream;
import net.jini.io.ObjectStreamContext;
import net.jini.security.SecurityContext;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.BasicUntrustedObjectSecurityContext;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.UntrustedObjectSecurityContext;

public class ProxyTrustVerifier
implements TrustVerifier {
    private static final Logger logger = Logger.getLogger("net.jini.security.trust");
    private static final ThreadLocal state = new ThreadLocal();
    private static Method gpvMethod;

    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        TrustVerifier verifier;
        if (obj == null || ctx == null) {
            throw new NullPointerException();
        }
        MethodConstraints mc = null;
        UntrustedObjectSecurityContext uosc = null;
        Iterator iter = ctx.getCallerContext().iterator();
        while ((mc == null || uosc == null) && iter.hasNext()) {
            Object elt = iter.next();
            if (mc == null && elt instanceof MethodConstraints) {
                MethodConstraints emc = (MethodConstraints)elt;
                if (emc.getConstraints(gpvMethod).isEmpty()) continue;
                mc = emc;
                continue;
            }
            if (uosc != null || !(elt instanceof UntrustedObjectSecurityContext)) continue;
            uosc = (UntrustedObjectSecurityContext)elt;
        }
        if (mc == null) {
            return false;
        }
        if (uosc == null) {
            uosc = new BasicUntrustedObjectSecurityContext(null);
        }
        return (verifier = ProxyTrustVerifier.getVerifier(obj, ctx, mc, uosc)) != null && verifier.isTrustedObject(obj, ctx);
    }

    private static TrustVerifier getVerifier(Object obj, TrustVerifier.Context ctx, MethodConstraints mc, UntrustedObjectSecurityContext uosc) throws RemoteException {
        ProxyTrustIterator iter;
        Method m = ProxyTrustVerifier.getMethod(obj);
        if (m == null) {
            if (!Proxy.isProxyClass(obj.getClass())) {
                return null;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(obj);
            m = ProxyTrustVerifier.getMethod(ih);
            if (m != null) {
                obj = ih;
            } else {
                if (obj instanceof ProxyTrust && obj instanceof RemoteMethodControl) {
                    return ProxyTrustVerifier.getAltVerifier(obj, ctx, mc);
                }
                return null;
            }
        }
        logger.log(Level.FINER, "{0} has ProxyTrustIterator", obj);
        SecurityContext rsc = uosc.getContext();
        try {
            iter = (ProxyTrustIterator)ProxyTrustVerifier.restrictedInvoke(m, obj, rsc);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw (Error)t;
        }
        RemoteException lastEx = null;
        while (ProxyTrustVerifier.restrictedHasNext(iter, rsc)) {
            obj = null;
            try {
                TrustVerifier verifier;
                obj = ProxyTrustVerifier.restrictedNext(iter, rsc);
                logger.log(Level.FINER, "ProxyTrustIterator produces {0}", obj);
                if (!(obj instanceof ProxyTrust)) {
                    verifier = ProxyTrustVerifier.getVerifier(obj, ctx, mc, uosc);
                    if (verifier == null) continue;
                    return verifier;
                }
                if (!(obj instanceof RemoteMethodControl)) continue;
                if (ProxyTrustVerifier.isTrusted(obj, ctx)) {
                    obj = ((RemoteMethodControl)obj).setConstraints(mc);
                    verifier = ((ProxyTrust)obj).getProxyVerifier();
                    logger.log(Level.FINE, "verifier is {0}", verifier);
                    return verifier;
                }
                if (!Proxy.isProxyClass(obj.getClass()) || ProxyTrustVerifier.getMethod(obj) != null || ProxyTrustVerifier.getMethod(Proxy.getInvocationHandler(obj)) != null || (verifier = ProxyTrustVerifier.getAltVerifier(obj, ctx, mc)) == null) continue;
                return verifier;
            }
            catch (RemoteException e) {
                lastEx = e;
                if (!(obj instanceof ProxyTrust)) continue;
                logger.log(Levels.HANDLED, "setting ProxyTrustIterator exception", e);
                ProxyTrustVerifier.restrictedSetException(iter, e, rsc);
            }
        }
        if (lastEx != null) {
            throw lastEx;
        }
        logger.log(Levels.FAILED, "no verifier obtained from ProxyTrustIterator");
        return null;
    }

    private static Object restrictedInvoke(final Method m, final Object obj, SecurityContext rsc) throws IllegalAccessException, InvocationTargetException {
        try {
            return AccessController.doPrivileged(rsc.wrap(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    return m.invoke(obj, null);
                }
            }), rsc.getAccessControlContext());
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof InvocationTargetException) {
                throw (InvocationTargetException)e;
            }
            throw (IllegalAccessException)e;
        }
    }

    private static boolean restrictedHasNext(final ProxyTrustIterator iter, SecurityContext rsc) {
        return (Boolean)AccessController.doPrivileged(rsc.wrap(new PrivilegedAction(){

            public Object run() {
                return iter.hasNext();
            }
        }), rsc.getAccessControlContext());
    }

    private static Object restrictedNext(final ProxyTrustIterator iter, SecurityContext rsc) throws RemoteException {
        try {
            return AccessController.doPrivileged(rsc.wrap(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return iter.next();
                }
            }), rsc.getAccessControlContext());
        }
        catch (PrivilegedActionException e) {
            throw (RemoteException)e.getException();
        }
    }

    private static void restrictedSetException(final ProxyTrustIterator iter, final RemoteException e, SecurityContext rsc) {
        AccessController.doPrivileged(rsc.wrap(new PrivilegedAction(){

            public Object run() {
                iter.setException(e);
                return null;
            }
        }), rsc.getAccessControlContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTrusted(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        Object saved = state.get();
        try {
            state.set(obj);
            boolean bl = ctx.isTrustedObject(obj);
            Object var5_4 = null;
            state.set(saved);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            state.set(saved);
            throw throwable;
        }
    }

    private static TrustVerifier getAltVerifier(Object obj, TrustVerifier.Context ctx, MethodConstraints mc) throws RemoteException {
        if (obj == state.get()) {
            return null;
        }
        final Class<?> base = obj.getClass();
        final String bcb = RMIClassLoader.getClassAnnotation(base);
        if (bcb == null || bcb.length() == 0) {
            return null;
        }
        final InvocationHandler ih = Proxy.getInvocationHandler(obj);
        if ((obj = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ClassLoader bcl = base.getClassLoader();
                if (bcl == null) {
                    return null;
                }
                ClassLoader pcl = bcl.getParent();
                Thread t = Thread.currentThread();
                ClassLoader ccl = t.getContextClassLoader();
                boolean proper = false;
                try {
                    try {
                        t.setContextClassLoader(pcl);
                        proper = RMIClassLoader.getClassLoader(bcb) == bcl;
                    }
                    catch (MalformedURLException e) {
                        Object var8_7 = null;
                        t.setContextClassLoader(ccl);
                    }
                    Object var8_6 = null;
                    t.setContextClassLoader(ccl);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    t.setContextClassLoader(ccl);
                    throw throwable;
                }
                if (proper) {
                    try {
                        return Proxy.newProxyInstance(pcl, new Class[]{ProxyTrust.class, RemoteMethodControl.class}, ih);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                return null;
            }
        })) == null) {
            return null;
        }
        logger.log(Level.FINER, "trying derivative bootstrap proxy {0}", obj);
        if (!ProxyTrustVerifier.isTrusted(obj, ctx)) {
            return null;
        }
        TrustVerifier verifier = ((ProxyTrust)(obj = ((RemoteMethodControl)obj).setConstraints(mc))).getProxyVerifier();
        final Class<?> vc = verifier.getClass();
        ClassLoader bcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader bcl = base.getClassLoader();
                if (bcl == vc.getClassLoader()) {
                    return null;
                }
                return bcl;
            }
        });
        if (bcl != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                MOStream out = new MOStream(bout, bcb, bcl);
                out.writeObject(verifier);
                out.close();
                if (out.replace) {
                    logger.log(Level.FINER, "remarshalling verifier");
                    MarshalInputStream in = new MarshalInputStream(new ByteArrayInputStream(bout.toByteArray()), bcl, false, null, Collections.EMPTY_SET);
                    in.useCodebaseAnnotations();
                    verifier = (TrustVerifier)in.readObject();
                    in.close();
                }
            }
            catch (IOException e) {
                throw new UnmarshalException("remarshalling verifier failed", e);
            }
            catch (ClassNotFoundException e) {
                throw new UnmarshalException("remarshalling verifier failed", e);
            }
        }
        logger.log(Level.FINE, "verifier is {0}", verifier);
        return verifier;
    }

    private static Method getMethod(Object obj) {
        final Class<?> base = obj.getClass();
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class c = base; c != null; c = c.getSuperclass()) {
                    try {
                        Method m = c.getDeclaredMethod("getProxyTrustIterator", new Class[0]);
                        if (ProxyTrustVerifier.usable(m, c, base)) {
                            m.setAccessible(true);
                            return m;
                        }
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
                return null;
            }
        });
    }

    private static boolean usable(Method m, Class c, Class base) {
        int mods = m.getModifiers();
        return m.getReturnType() == ProxyTrustIterator.class && m.getExceptionTypes().length == 0 && (mods & 8) == 0 && ((mods & 5) != 0 || ((mods & 2) != 0 ? c == base : ProxyTrustVerifier.samePackage(c, base)));
    }

    private static boolean samePackage(Class c1, Class c2) {
        if (c1.getClassLoader() == c2.getClassLoader()) {
            String n2;
            int i2;
            String n1 = c1.getName();
            int i1 = n1.lastIndexOf(46);
            return i1 == (i2 = (n2 = c2.getName()).lastIndexOf(46)) && (i1 < 0 || n1.regionMatches(0, n2, 0, i1));
        }
        return false;
    }

    static {
        try {
            gpvMethod = ProxyTrust.class.getMethod("getProxyVerifier", new Class[0]);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class MOStream
    extends ObjectOutputStream
    implements ObjectStreamContext {
        private final String bcb;
        private final ClassLoader bcl;
        boolean replace = false;

        MOStream(ByteArrayOutputStream out, String bcb, ClassLoader bcl) throws IOException {
            super(out);
            this.bcb = bcb;
            this.bcl = bcl;
        }

        public Collection getObjectStreamContext() {
            return Collections.EMPTY_SET;
        }

        protected void annotateClass(Class c) throws IOException {
            this.writeAnnotation(c);
        }

        protected void annotateProxyClass(Class c) throws IOException {
            this.writeAnnotation(c);
        }

        private void writeAnnotation(final Class c) throws IOException {
            String cb = RMIClassLoader.getClassAnnotation(c);
            this.writeObject(cb);
            if (this.bcb.equals(cb)) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (c.getClassLoader() != MOStream.this.bcl) {
                            MOStream.this.replace = true;
                        }
                        return null;
                    }
                });
            }
        }
    }
}

