/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.jeri.BasicInvocationHandler;
import net.jini.jeri.BasicObjectEndpoint;
import net.jini.security.Security;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

public class BasicJeriTrustVerifier
implements TrustVerifier {
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        if (obj == null || ctx == null) {
            throw new NullPointerException();
        }
        if (obj instanceof RemoteMethodControl) {
            Class<?> c = obj.getClass();
            if (Proxy.isProxyClass(c)) {
                if (!this.hasTrustedProxyClass(obj, ctx)) {
                    return false;
                }
                InvocationHandler handler = Proxy.getInvocationHandler(obj);
                return this.isTrustedInvocationHandler(handler, ctx);
            }
        } else if (obj.getClass() == BasicObjectEndpoint.class) {
            BasicObjectEndpoint oe = (BasicObjectEndpoint)obj;
            return ctx.isTrustedObject(oe.getEndpoint());
        }
        return false;
    }

    protected boolean hasTrustedProxyClass(Object proxy, TrustVerifier.Context ctx) throws RemoteException {
        Class<?> c = proxy.getClass();
        if (ctx == null) {
            throw new NullPointerException();
        }
        if (!(proxy instanceof Remote) || !this.hasTrustedClassLoader(proxy, ctx)) {
            return false;
        }
        Class<?>[] interfaces = c.getInterfaces();
        int i = interfaces.length;
        while (--i >= 0) {
            if (this.isTrustedProxyInterface(interfaces[i], ctx)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasTrustedClassLoader(Object proxy, final TrustVerifier.Context ctx) throws RemoteException {
        final Class<?> c = proxy.getClass();
        if (!Proxy.isProxyClass(c)) {
            throw new IllegalArgumentException("Proxy must be an instance of a dynamic proxy class");
        }
        Boolean b = (Boolean)Security.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = ctx.getClassLoader();
                if (cl == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                return BasicJeriTrustVerifier.covers(cl, c.getClassLoader());
            }
        });
        return b;
    }

    protected boolean isTrustedProxyInterface(Class intf, TrustVerifier.Context ctx) throws RemoteException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        if (intf == RemoteMethodControl.class || intf == TrustEquivalence.class) {
            return true;
        }
        if (!Remote.class.isAssignableFrom(intf) || !intf.isInterface()) {
            return false;
        }
        Method[] methods = intf.getMethods();
        int i = methods.length;
        block0: while (--i >= 0) {
            Class<?>[] exceptions = methods[i].getExceptionTypes();
            int j = exceptions.length;
            while (--j >= 0) {
                if (!exceptions[j].isAssignableFrom(RemoteException.class)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    protected boolean isTrustedInvocationHandler(InvocationHandler handler, TrustVerifier.Context ctx) throws RemoteException {
        if (handler.getClass() != BasicInvocationHandler.class) {
            return false;
        }
        return BasicJeriTrustVerifier.checkInvocationHandlerContent((BasicInvocationHandler)handler, ctx);
    }

    protected static boolean checkInvocationHandlerContent(BasicInvocationHandler handler, TrustVerifier.Context ctx) throws RemoteException {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        MethodConstraints serverConstraints = handler.getServerConstraints();
        return ctx.isTrustedObject(handler.getObjectEndpoint()) && ctx.isTrustedObject(serverConstraints);
    }

    private static boolean covers(ClassLoader sub, ClassLoader sup) {
        if (sup == null) {
            return true;
        }
        if (sub == null) {
            return false;
        }
        do {
            if (sub != sup) continue;
            return true;
        } while ((sub = sub.getParent()) != null);
        return false;
    }
}

