/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public class BasicInvocationHandler
implements InvocationHandler,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -783920361025791412L;
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicInvocationHandler");
    private static final int CACHE_SIZE = 3;
    private final ObjectEndpoint oe;
    private final MethodConstraints clientConstraints;
    private final MethodConstraints serverConstraints;
    private transient Object cacheLock = new Object();
    private transient int cacheIndex;
    private transient Method[] methodCache;
    private transient InvocationConstraints[] constraintCache;

    public BasicInvocationHandler(ObjectEndpoint oe, MethodConstraints serverConstraints) {
        if (oe == null) {
            throw new NullPointerException();
        }
        this.oe = oe;
        this.clientConstraints = null;
        this.serverConstraints = serverConstraints;
    }

    public BasicInvocationHandler(BasicInvocationHandler other, MethodConstraints clientConstraints) {
        this.oe = other.oe;
        this.clientConstraints = clientConstraints;
        this.serverConstraints = other.serverConstraints;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (proxy instanceof InvocationHandler) {
            throw new IllegalArgumentException("proxy cannot be an invocation handler");
        }
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        if (method.getDeclaringClass() == RemoteMethodControl.class) {
            return this.invokeRemoteMethodControlMethod(proxy, method, args);
        }
        if (method.getDeclaringClass() == TrustEquivalence.class) {
            return this.invokeTrustEquivalenceMethod(proxy, method, args);
        }
        return this.invokeRemoteMethod(proxy, method, args);
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (name.equals("equals")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Util.sameProxyClass(proxy, obj) && this.equals(Proxy.getInvocationHandler(obj));
            return b;
        }
        if (name.equals("toString")) {
            return this.proxyToString(proxy);
        }
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    private Object invokeRemoteMethodControlMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("setConstraints")) {
            if (Proxy.getInvocationHandler(proxy) != this) {
                throw new IllegalArgumentException("not proxy for this");
            }
            Class<?> proxyClass = proxy.getClass();
            return Proxy.newProxyInstance(BasicInvocationHandler.getProxyLoader(proxyClass), proxyClass.getInterfaces(), this.setClientConstraints((MethodConstraints)args[0]));
        }
        if (name.equals("getConstraints")) {
            return this.clientConstraints;
        }
        throw new AssertionError(method);
    }

    private Object invokeTrustEquivalenceMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("checkTrustEquivalence")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Util.sameProxyClass(proxy, obj) && this.checkTrustEquivalence(Proxy.getInvocationHandler(obj));
            return b;
        }
        throw new AssertionError(method);
    }

    private Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws Throwable {
        OutboundRequestIterator iter;
        Util.checkProxyRemoteMethod(proxy.getClass(), method);
        InvocationConstraints constraints = this.getConstraints(method);
        if (logger.isLoggable(Level.FINE)) {
            this.logCall(method, args, constraints);
        }
        if (!(iter = this.oe.newCall(constraints)).hasNext()) {
            throw new ConnectIOException("iterator produced no requests", new IOException("iterator produced no requests"));
        }
        Failure failure = null;
        do {
            Object result;
            if (logger.isLoggable(Levels.HANDLED) && failure != null) {
                this.logThrow(Levels.HANDLED, method, failure.exception, false);
            }
            if (!((result = this.invokeRemoteMethodOnce(proxy, method, args, iter, constraints)) instanceof Failure)) {
                return result;
            }
            failure = (Failure)result;
        } while (failure.retry && iter.hasNext());
        if (logger.isLoggable(Levels.FAILED) && failure != null) {
            this.logThrow(Levels.FAILED, method, failure.exception, false);
        }
        throw failure.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteMethodOnce(Object proxy, Method method, Object[] args, OutboundRequestIterator iter, InvocationConstraints constraints) throws Throwable {
        ArrayList context;
        OutboundRequest request;
        try {
            request = iter.next();
        }
        catch (Exception e2) {
            RemoteException e2;
            if (e2 instanceof IOException) {
                e2 = BasicInvocationHandler.wrapSafeIOException((IOException)e2, this.oe);
            }
            return new Failure(e2, true);
        }
        boolean ok = false;
        boolean integrity = false;
        boolean wroteMethod = false;
        try {
            try {
                InvocationConstraints unfulfilled = request.getUnfulfilledConstraints();
                for (InvocationConstraint c : unfulfilled.requirements()) {
                    if (c == Integrity.YES) {
                        integrity = true;
                        continue;
                    }
                    if (c instanceof Integrity) continue;
                    throw new UnsupportedConstraintException("cannot satisfy unfulfilled constraint: " + c);
                }
                if (!integrity) {
                    for (InvocationConstraint c : unfulfilled.preferences()) {
                        if (c != Integrity.YES) continue;
                        integrity = true;
                        break;
                    }
                }
                OutputStream ros = request.getRequestOutputStream();
                ros.write(0);
                ros.write(integrity ? 1 : 0);
                context = new ArrayList(1);
                Util.populateContext(context, integrity);
                ObjectOutputStream out = this.createMarshalOutputStream(proxy, method, request, context);
                wroteMethod = true;
                this.marshalMethod(proxy, method, out, context);
                args = args == null ? new Object[]{} : args;
                this.marshalArguments(proxy, method, args, out, context);
                out.close();
                ok = true;
            }
            catch (Exception e3) {
                RemoteException e3;
                if (e3 instanceof IOException) {
                    e3 = wroteMethod && request.getDeliveryStatus() ? new MarshalException("error marshalling arguments", e3) : BasicInvocationHandler.wrapSafeIOException((IOException)e3, this.oe);
                }
                Failure ros = new Failure(e3, !wroteMethod || !request.getDeliveryStatus());
                Object var15_21 = null;
                if (!ok) {
                    request.abort();
                }
                return ros;
            }
            Object var15_20 = null;
            if (!ok) {
                request.abort();
            }
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            if (!ok) {
                request.abort();
            }
            throw throwable;
        }
        ok = false;
        boolean versionMismatch = false;
        Object returnValue = null;
        Throwable throwable = null;
        try {
            try {
                throwable = this.oe.executeCall(request);
                if (throwable == null) {
                    InputStream ris = request.getResponseInputStream();
                    int responseCode = ris.read();
                    if (responseCode == -1) {
                        throw new EOFException("connection closed by server");
                    }
                    if (responseCode == 0) {
                        versionMismatch = true;
                        throw new ProtocolException("marshalling protocol version mismatch");
                    }
                    ObjectInputStream in = this.createMarshalInputStream(proxy, method, request, integrity, context);
                    switch (responseCode) {
                        case 1: {
                            returnValue = this.unmarshalReturn(proxy, method, in, context);
                            if (!logger.isLoggable(Level.FINE)) break;
                            this.logReturn(method, returnValue);
                            break;
                        }
                        case 2: {
                            throwable = this.unmarshalThrow(proxy, method, in, context);
                            break;
                        }
                        default: {
                            throw new ProtocolException("invalid response code " + responseCode);
                        }
                    }
                    in.close();
                }
                ok = true;
            }
            catch (Exception e22) {
                RemoteException e22;
                boolean retry = false;
                if (e22 instanceof IOException) {
                    if (!versionMismatch && request.getDeliveryStatus()) {
                        e22 = new UnmarshalException("exception unmarshalling response", e22);
                    } else {
                        e22 = BasicInvocationHandler.wrapSafeIOException((IOException)e22, this.oe);
                        retry = !versionMismatch;
                    }
                } else if (e22 instanceof ClassNotFoundException) {
                    e22 = new UnmarshalException("error unmarshalling response", e22);
                }
                Failure failure = new Failure(e22, !versionMismatch || !request.getDeliveryStatus());
                Object var18_32 = null;
                if (!ok) {
                    request.abort();
                }
                return failure;
            }
            Object var18_31 = null;
            if (!ok) {
                request.abort();
            }
        }
        catch (Throwable throwable2) {
            Object var18_33 = null;
            if (!ok) {
                request.abort();
            }
            throw throwable2;
        }
        if (throwable != null) {
            if (logger.isLoggable(Levels.FAILED)) {
                this.logThrow(Levels.FAILED, method, throwable, true);
            }
            throw throwable;
        }
        return returnValue;
    }

    private static RemoteException wrapSafeIOException(IOException ioe, ObjectEndpoint oe) {
        if (ioe instanceof UnknownHostException) {
            return new java.rmi.UnknownHostException("unknown host in " + oe, ioe);
        }
        if (ioe instanceof ConnectException) {
            return new java.rmi.ConnectException("connection refused or timed out to " + oe, ioe);
        }
        return new ConnectIOException("I/O exception connecting to " + oe, ioe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvocationConstraints getConstraints(Method method) {
        if (this.clientConstraints == null && this.serverConstraints == null) {
            return InvocationConstraints.EMPTY;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.methodCache == null) {
                this.methodCache = new Method[3];
                this.constraintCache = new InvocationConstraints[3];
                this.cacheIndex = 2;
            } else {
                int i = 3;
                while (--i >= 0) {
                    if (this.methodCache[i] != method) continue;
                    return this.constraintCache[i].makeAbsolute();
                }
            }
            InvocationConstraints constraints = InvocationConstraints.combine(this.clientConstraints == null ? null : this.clientConstraints.getConstraints(method), this.serverConstraints == null ? null : this.serverConstraints.getConstraints(method));
            this.methodCache[this.cacheIndex] = method;
            this.constraintCache[this.cacheIndex] = constraints;
            this.cacheIndex = this.cacheIndex == 0 ? 2 : this.cacheIndex - 1;
            return constraints.makeAbsolute();
        }
    }

    protected InvocationHandler setClientConstraints(MethodConstraints constraints) {
        Class<?> c = this.getClass();
        try {
            Constructor<?> constructor = c.getConstructor(c, MethodConstraints.class);
            return (BasicInvocationHandler)constructor.newInstance(this, constraints);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "exception constructing invocation handler");
        }
    }

    protected ObjectOutputStream createMarshalOutputStream(Object proxy, Method method, OutboundRequest request, Collection context) throws IOException {
        if (proxy == null || method == null) {
            throw new NullPointerException();
        }
        OutputStream out = request.getRequestOutputStream();
        Collection unmodContext = Collections.unmodifiableCollection(context);
        return new MarshalOutputStream(out, unmodContext);
    }

    protected ObjectInputStream createMarshalInputStream(Object proxy, Method method, OutboundRequest request, boolean integrity, Collection context) throws IOException {
        if (method == null) {
            throw new NullPointerException();
        }
        if (Proxy.getInvocationHandler(proxy) != this) {
            throw new IllegalArgumentException("not proxy for this");
        }
        ClassLoader proxyLoader = BasicInvocationHandler.getProxyLoader(proxy.getClass());
        Collection unmodContext = Collections.unmodifiableCollection(context);
        MarshalInputStream in = new MarshalInputStream(request.getResponseInputStream(), proxyLoader, integrity, proxyLoader, unmodContext);
        in.useCodebaseAnnotations();
        return in;
    }

    private static ClassLoader getProxyLoader(final Class proxyClass) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return proxyClass.getClassLoader();
            }
        });
    }

    protected void marshalMethod(Object proxy, Method method, ObjectOutputStream out, Collection context) throws IOException {
        if (proxy == null || method == null || context == null) {
            throw new NullPointerException();
        }
        out.writeLong(Util.getMethodHash(method));
    }

    protected void marshalArguments(Object proxy, Method method, Object[] args, ObjectOutputStream out, Collection context) throws IOException {
        if (proxy == null || args == null || out == null || context == null) {
            throw new NullPointerException();
        }
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Util.marshalValue(types[i], args[i], out);
        }
    }

    protected Object unmarshalReturn(Object proxy, Method method, ObjectInputStream in, Collection context) throws IOException, ClassNotFoundException {
        if (proxy == null || in == null || context == null) {
            throw new NullPointerException();
        }
        Class<?> returnType = method.getReturnType();
        Object returnValue = null;
        if (returnType != Void.TYPE) {
            returnValue = Util.unmarshalValue(returnType, in);
        }
        return returnValue;
    }

    protected Throwable unmarshalThrow(Object proxy, Method method, ObjectInputStream in, Collection context) throws IOException, ClassNotFoundException {
        if (proxy == null || method == null || context == null) {
            throw new NullPointerException();
        }
        Throwable t = (Throwable)in.readObject();
        Util.exceptionReceivedFromServer(t);
        if (!(t instanceof RuntimeException) && !(t instanceof Error)) {
            Class<?> cl = proxy.getClass();
            try {
                method = cl.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
            }
            Class<?>[] exTypes = method.getExceptionTypes();
            Class<?> thrownType = t.getClass();
            for (int i = 0; i < exTypes.length; ++i) {
                if (!exTypes[i].isAssignableFrom(thrownType)) continue;
                return t;
            }
            UnexpectedException wrapper = new UnexpectedException("unexpected exception");
            wrapper.detail = t;
            t = wrapper;
        }
        return t;
    }

    private void logCall(Method method, Object[] args, InvocationConstraints constraints) {
        String msg = "outbound call {0}.{1} to {2}\n{3}";
        if (logger.isLoggable(Level.FINEST)) {
            msg = "outbound call {0}.{1} to {2}\nargs {4}\n{3}";
        }
        List<Object> xargs = args == null ? Collections.EMPTY_LIST : Arrays.asList(args);
        logger.logp(Level.FINE, this.getClass().getName(), "invoke", msg, new Object[]{method.getDeclaringClass().getName(), method.getName(), this.oe, constraints, xargs});
    }

    private void logReturn(Method method, Object res) {
        String msg = "outbound call {0}.{1} returns";
        if (logger.isLoggable(Level.FINEST) && method.getReturnType() != Void.TYPE) {
            msg = "outbound call {0}.{1} returns {2}";
        }
        logger.logp(Level.FINE, this.getClass().getName(), "invoke", msg, new Object[]{method.getDeclaringClass().getName(), method.getName(), res});
    }

    private void logThrow(Level level, Method method, Throwable t, boolean isRemote) {
        LogRecord lr = new LogRecord(level, isRemote ? "outbound call {0}.{1} remotely throws" : "outbound call {0}.{1} locally throws");
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(this.getClass().getName());
        lr.setSourceMethodName("invoke");
        lr.setParameters(new Object[]{method.getDeclaringClass().getName(), method.getName()});
        lr.setThrown(t);
        logger.log(lr);
    }

    public final ObjectEndpoint getObjectEndpoint() {
        return this.oe;
    }

    public final MethodConstraints getClientConstraints() {
        return this.clientConstraints;
    }

    public final MethodConstraints getServerConstraints() {
        return this.serverConstraints;
    }

    public int hashCode() {
        return this.oe.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicInvocationHandler other = (BasicInvocationHandler)obj;
        return Util.sameClassAndEquals(this.oe, other.oe) && Util.equals(this.clientConstraints, other.clientConstraints) && Util.equals(this.serverConstraints, other.serverConstraints);
    }

    public boolean checkTrustEquivalence(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicInvocationHandler other = (BasicInvocationHandler)obj;
        return Util.checkTrustEquivalence(this.oe, other.oe) && Util.equals(this.clientConstraints, other.clientConstraints) && Util.equals(this.serverConstraints, other.serverConstraints);
    }

    public String toString() {
        return Util.getUnqualifiedName(this.getClass()) + "[" + this.oe + "]";
    }

    private String proxyToString(Object proxy) {
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        if (interfaces.length == 0) {
            return "Proxy[" + this + "]";
        }
        String iface = interfaces[0].getName();
        int dot = iface.lastIndexOf(46);
        if (dot >= 0) {
            iface = iface.substring(dot + 1);
        }
        return "Proxy[" + iface + "," + this + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.oe == null) {
            throw new InvalidObjectException("null object endpoint");
        }
        this.cacheLock = new Object();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream; class: " + this.getClass().getName());
    }

    private static class Failure {
        final Throwable exception;
        final boolean retry;

        Failure(Throwable exception, boolean retry) {
            this.exception = exception;
            this.retry = retry;
        }
    }
}

