/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup.ui.attribute;

import com.artima.lookup.util.ConsistentSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class Locales
implements Serializable {
    private static final long serialVersionUID = -8904904794408873606L;
    private Set supportedLocales;

    public Locales(Set locales) {
        if (locales == null) {
            throw new NullPointerException();
        }
        for (Object o : locales) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (o instanceof Locale) continue;
            throw new IllegalArgumentException();
        }
        this.supportedLocales = new ConsistentSet((Collection)locales);
    }

    public boolean isLocaleSupported(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        return this.supportedLocales.contains(locale);
    }

    public Locale getFirstSupportedLocale(Locale[] locales) {
        if (locales == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < locales.length; ++i) {
            if (!this.supportedLocales.contains(locales[i])) continue;
            return locales[i];
        }
        return null;
    }

    public Locale getFirstSupportedLocale(List locales) {
        if (locales == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < locales.size(); ++i) {
            if (!this.supportedLocales.contains(locales.get(i))) continue;
            try {
                return (Locale)locales.get(i);
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        return null;
    }

    public Iterator iterator() {
        return this.supportedLocales.iterator();
    }

    public Set getLocales() {
        return this.supportedLocales;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != Locales.class) {
            return false;
        }
        Locales locales = (Locales)o;
        return this.supportedLocales.equals(locales.supportedLocales);
    }

    public int hashCode() {
        return this.supportedLocales.hashCode();
    }
}

