/*
 * Decompiled with CFR 0.152.
 */
package net.jini.entry;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;

public class UnusableEntriesException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Collection entries;
    private final Collection exceptions;

    public UnusableEntriesException(String s, Collection entries, Collection exceptions) {
        super(s);
        if (entries == null) {
            this.entries = Collections.EMPTY_SET;
        } else {
            for (Object e : entries) {
                if (e == null) {
                    throw new NullPointerException("entries contains a null value");
                }
                if (e instanceof Entry) continue;
                throw new IllegalArgumentException("entries contains a value which is not an entry");
            }
            this.entries = entries;
        }
        Iterator i = exceptions.iterator();
        while (i.hasNext()) {
            if (i == null) {
                throw new NullPointerException("exceptions contains a null value");
            }
            if (i.next() instanceof UnusableEntryException) continue;
            throw new IllegalArgumentException("exceptions contains a value which is not an UnusableEntryException");
        }
        this.exceptions = exceptions;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.exceptions == null) {
            throw new InvalidObjectException("exceptions field is null");
        }
        if (this.exceptions.isEmpty()) {
            throw new InvalidObjectException("exceptions field contains an empty collection");
        }
        for (Object e : this.exceptions) {
            if (e == null) {
                throw new InvalidObjectException("The Collection referenced by the exceptions field contains a null element");
            }
            if (e instanceof UnusableEntryException) continue;
            throw new InvalidObjectException("The Collection referenced by the exceptions field contains an element which is not an UnusableEntryException");
        }
        if (this.entries == null) {
            throw new InvalidObjectException("entries field is null");
        }
        for (Object e : this.entries) {
            if (e == null) {
                throw new InvalidObjectException("The Collection referenced by the entries field contains a null element");
            }
            if (e instanceof Entry) continue;
            throw new InvalidObjectException("The Collection referenced by the entries field contains an element which is not an Entry");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("UnusableEntriesException should always have data");
    }

    public Collection getEntries() {
        return this.entries;
    }

    public Collection getUnusableEntryExceptions() {
        return this.exceptions;
    }
}

