/*
 * Decompiled with CFR 0.152.
 */
package uk.co.sleonard.accounts.web;

import com.leonarduk.core.FileUtils;
import com.leonarduk.web.BaseSeleniumPage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import uk.co.sleonard.accounts.web.NationwideLogin;

public class NationwideAccount
extends BaseSeleniumPage {
    private static final Logger _logger = Logger.getLogger(NationwideAccount.class);
    private NationwideLogin login;
    private FileType fileType;

    public static void main(String[] args) throws IOException {
        String downloadDir = "/home/stephen/Downloads/";
        File tempDir = FileUtils.createTempDir();
        ChromeDriver downloadCapableBrowser = new ChromeDriver();
        FileType type = FileType.OFX;
        NationwideAccount nationwideAccount = (NationwideAccount)new NationwideAccount(new NationwideLogin((WebDriver)downloadCapableBrowser, "2901722608", "olympia", "971659"), 1, type).get();
        File[] files = tempDir.listFiles();
        if (files.length > 0) {
            files[0].renameTo(new File(downloadDir + nationwideAccount.createFileName() + "." + type.name().toLowerCase()));
        }
    }

    public NationwideAccount(NationwideLogin aLogin, int aAccountId, FileType aFileType) {
        super(aLogin.getWebDriver(), "https://onlinebanking.nationwide.co.uk/Transactions/FullStatement/FullStatement/" + aAccountId);
        this.login = aLogin;
        this.fileType = aFileType;
    }

    protected final void load() {
        if (this.getWebDriver().findElements(By.id((String)"logoutForm")).size() == 0) {
            this.login.get();
        }
        this.downloadForAccount();
    }

    private void downloadForAccount() {
        this.getWebDriver().get(this.getExpectedUrl());
        try {
            this.getWebDriver().switchTo().alert().accept();
        }
        catch (NoAlertPresentException e) {
            System.out.println("no alert to close");
        }
        List downloadLinks = this.getWebDriver().findElements(By.cssSelector((String)"a.downloadFileLink.custom-tooltip-link"));
        if (downloadLinks.size() < 1 || !((WebElement)downloadLinks.get(0)).isDisplayed()) {
            return;
        }
        ((WebElement)downloadLinks.get(0)).click();
        this.getWebDriver().findElement(By.xpath((String)"(//form[@action='/Transactions/FullStatement/DownloadFS'])[2]")).click();
        this.getWebDriver().findElement(By.cssSelector((String)"b.reveal-info-down")).click();
        this.getWebDriver().findElement(By.linkText((String)("Download " + (Object)((Object)this.fileType) + " file"))).click();
    }

    public final String accountName() {
        this.get();
        return this.getWebDriver().findElement(By.xpath((String)"//*[@id=\"stageInner\"]/div[3]/h2")).getText();
    }

    public final String getDates() {
        this.get();
        return this.getWebDriver().findElement(By.id((String)"date-display-dates")).getText();
    }

    public final String createFileName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.accountName().replaceAll(" ", "_"));
        buf.append("_");
        buf.append(this.getDates().replaceAll(" ", "_"));
        return buf.toString();
    }

    public static enum FileType {
        CSV,
        OFX;

    }
}

