/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.bookkeeper;

import com.leonarduk.bookkeeper.web.FreeAgentLogin;
import com.leonarduk.bookkeeper.web.FreeAgentUploadTransactions;
import com.leonarduk.bookkeeper.web.SantanderDownloadTransactions;
import com.leonarduk.bookkeeper.web.SantanderLogin;
import com.leonarduk.core.FileUtils;
import com.leonarduk.core.config.Config;
import com.leonarduk.core.email.EmailException;
import com.leonarduk.core.email.EmailSender;
import com.leonarduk.core.email.EmailSession;
import com.leonarduk.core.format.HtmlFormatter;
import com.leonarduk.web.SeleniumUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebDriver;
import uk.co.sleonard.accounts.web.AllianceTrust;
import uk.co.sleonard.accounts.web.AmexDownloadTransactions;
import uk.co.sleonard.accounts.web.NationwideAccount;
import uk.co.sleonard.accounts.web.NationwideLogin;
import uk.co.sleonard.accounts.web.UploadToClearCheckbook;
import uk.co.sleonard.accounts.web.ZooplaEstimate;

public final class BankSynch {
    static final Logger LOGGER = Logger.getLogger(BankSynch.class);

    private static void emailNotification(Config config, StringBuilder changes) throws EmailException {
        String[] toEmail = config.getArrayProperty("bookkeeper.email.to");
        String user = config.getProperty("bookkeeper.email.user");
        String server = config.getProperty("bookkeeper.email.server");
        String password = config.getProperty("bookkeeper.email.password");
        String port = config.getProperty("bookkeeper.email.port");
        EmailSender emailSender = new EmailSender();
        EmailSession session = new EmailSession(user, password, server, port);
        emailSender.sendMessage(config.getProperty("bookkeeper.email.from.email"), config.getProperty("bookkeeper.email.from.name"), "Uploaded bank transactions to Freeagent and Clearcheckbook", changes.toString(), true, session, toEmail);
    }

    private static void getSantanderTransactions(Config config, WebDriver webDriver) {
        SantanderDownloadTransactions santanderLogin = new SantanderDownloadTransactions(new SantanderLogin(webDriver, config));
        santanderLogin.get();
        santanderLogin.downloadTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean processSantander = false;
        boolean processLeonardUK = false;
        boolean processAmex = false;
        boolean processNationwide = true;
        boolean processZoopla = false;
        boolean processAllianceTrust = false;
        Config config = new Config("bookkeeper.properties");
        File tempDir = FileUtils.createTempDir();
        WebDriver webDriver = SeleniumUtils.getDownloadCapableBrowser((File)tempDir);
        WebDriver freeAgentWebdriver = SeleniumUtils.getDownloadCapableBrowser((File)tempDir);
        try {
            HtmlFormatter formatter = new HtmlFormatter();
            StringBuilder changes = new StringBuilder();
            BankSynch.processSantander(processSantander, config, tempDir, webDriver, freeAgentWebdriver, formatter, changes);
            String ccbuserName = "stevel56";
            String ccbpassword = "N0bigm0mas!";
            BankSynch.processLeonardUK(processLeonardUK, config, webDriver, freeAgentWebdriver, formatter, changes, ccbuserName, ccbpassword);
            BankSynch.processAmex(processAmex, tempDir, webDriver, freeAgentWebdriver, formatter, changes);
            BankSynch.processNationwide(processNationwide, tempDir, webDriver, freeAgentWebdriver, formatter, changes, ccbuserName, ccbpassword);
            BankSynch.processZoopla(processZoopla, webDriver, freeAgentWebdriver, formatter, changes, ccbuserName, ccbpassword);
            BankSynch.processAllianceTrust(processAllianceTrust, webDriver, freeAgentWebdriver, formatter, changes, ccbuserName, ccbpassword);
            BankSynch.emailNotification(config, changes);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Failed", e);
            System.exit(1);
        }
        finally {
            webDriver.close();
            freeAgentWebdriver.close();
        }
    }

    private static void processAllianceTrust(boolean processAllianceTrust, WebDriver webDriver, WebDriver freeAgentWebdriver, HtmlFormatter formatter, StringBuilder changes, String ccbuserName, String ccbpassword) {
        if (processAllianceTrust) {
            try {
                String steveaccount = "155266";
                String lucyAccount = "155385";
                AllianceTrust trust = new AllianceTrust(webDriver);
                trust.get();
                String pensionValue = trust.getValue(1, steveaccount);
                System.out.println("Pension:" + pensionValue);
                String steveLisaValue = trust.getValue(2, steveaccount);
                System.out.println("Steve ISA:" + steveLisaValue);
                String lucyIsaValue = trust.getValue(1, lucyAccount);
                System.out.println("Lucy ISA:" + lucyIsaValue);
                String pension = UploadToClearCheckbook.updateEstimate("AT SIPP (StockMarket)", pensionValue, ccbuserName, ccbpassword, freeAgentWebdriver, "//*[@id=\"account-overviews\"]/div[3]/div[3]", "Updated from Alliance Trust");
                BankSynch.addSectionToEmail(formatter, changes, "AT SIPP (StockMarket)", pension);
                String steveIsa = UploadToClearCheckbook.updateEstimate("AT ISA Steve (StockMarket)", steveLisaValue, ccbuserName, ccbpassword, freeAgentWebdriver, "//*[@id=\"account-overviews\"]/div[2]/div[3]", "Updated from Alliance Trust");
                BankSynch.addSectionToEmail(formatter, changes, "Steve ISA", steveIsa);
                String lucyISA = UploadToClearCheckbook.updateEstimate("AT ISA Lucy (StockMarket)", lucyIsaValue, ccbuserName, ccbpassword, freeAgentWebdriver, "//*[@id=\"account-overviews\"]/div[1]/div[3]", "Updated from Alliance Trust");
                BankSynch.addSectionToEmail(formatter, changes, "Lucy ISA", lucyISA);
            }
            catch (Exception e) {
                changes.append(e.getMessage());
            }
        }
    }

    private static void processZoopla(boolean processZoopla, WebDriver webDriver, WebDriver freeAgentWebdriver, HtmlFormatter formatter, StringBuilder changes, String ccbuserName, String ccbpassword) {
        String account = "RE - 60 Willoughby Road (Illiquid)";
        if (processZoopla) {
            try {
                ZooplaEstimate zooplaEstimate = new ZooplaEstimate(webDriver);
                zooplaEstimate.get();
                String estimate = zooplaEstimate.getEstimate();
                String valueXpath = "//*[@id=\"account-overviews\"]/div[29]/div[3]";
                String memo = "Updated from Zoopla estimate";
                String zoopla = UploadToClearCheckbook.updateEstimate(account, estimate, ccbuserName, ccbpassword, freeAgentWebdriver, valueXpath, memo);
                BankSynch.addSectionToEmail(formatter, changes, account, zoopla);
            }
            catch (Exception e) {
                BankSynch.addSectionToEmail(formatter, changes, account, e.getMessage());
            }
        }
    }

    private static void processNationwide(boolean processNationwide, File tempDir, WebDriver webDriver, WebDriver freeAgentWebdriver, HtmlFormatter formatter, StringBuilder changes, String ccbuserName, String ccbpassword) {
        if (processNationwide) {
            HashMap<String, Integer> nationwideAccounts = new HashMap<String, Integer>();
            nationwideAccounts.put("NT - Joint", 1);
            nationwideAccounts.put("NT Steve Current", 0);
            int steveIsaIndex = 9;
            nationwideAccounts.put("NT - ISA Steve", 9);
            int alexIsaIndex = 7;
            nationwideAccounts.put("NT - ISA Alex (3720 per year", 7);
            int loyaltySaverIndex = 8;
            nationwideAccounts.put("NT Loyalty Saver", 8);
            for (Map.Entry entry : nationwideAccounts.entrySet()) {
                try {
                    String transactions = BankSynch.uploadNationwideJointToClearcheckbook(tempDir, webDriver, freeAgentWebdriver, (Integer)entry.getValue(), (String)entry.getKey(), ccbuserName, ccbpassword);
                    BankSynch.addSectionToEmail(formatter, changes, (String)entry.getKey(), transactions);
                }
                catch (Exception e) {
                    BankSynch.addSectionToEmail(formatter, changes, (String)entry.getKey(), e.getMessage());
                }
            }
        }
    }

    private static void processAmex(boolean processAmex, File tempDir, WebDriver webDriver, WebDriver freeAgentWebdriver, HtmlFormatter formatter, StringBuilder changes) {
        if (processAmex) {
            try {
                String amex = "CC - AMEX";
                String amexUploads = BankSynch.uploadAmexToClearcheckbook(tempDir, webDriver, amex, freeAgentWebdriver);
                BankSynch.addSectionToEmail(formatter, changes, amex, amexUploads);
                LOGGER.info((Object)(amex + amexUploads));
            }
            catch (Exception e) {
                changes.append(e.getMessage());
            }
        }
    }

    private static void processLeonardUK(boolean processLeonardUK, Config config, WebDriver webDriver, WebDriver freeAgentWebdriver, HtmlFormatter formatter, StringBuilder changes, String ccbuserName, String ccbpassword) {
        if (processLeonardUK) {
            String account = "Leonard UK profits";
            try {
                FreeAgentLogin freeAgentLogin = new FreeAgentLogin(webDriver, config);
                freeAgentLogin.get();
                String leonardUKProfits = freeAgentLogin.getProfits();
                String valueXpath = "//*[@id=\"account-overviews\"]/div[12]/div[3]";
                String memo = "Updated from FreeAgent";
                String transactions = UploadToClearCheckbook.updateEstimate(account, leonardUKProfits, ccbuserName, ccbpassword, freeAgentWebdriver, valueXpath, memo);
                BankSynch.addSectionToEmail(formatter, changes, account, transactions);
            }
            catch (Exception e) {
                BankSynch.addSectionToEmail(formatter, changes, account, e.getMessage());
            }
        }
    }

    private static void processSantander(boolean processSantander, Config config, File tempDir, WebDriver webDriver, WebDriver freeAgentWebdriver, HtmlFormatter formatter, StringBuilder changes) {
        if (processSantander) {
            try {
                BankSynch.getSantanderTransactions(config, webDriver);
                String santander = BankSynch.uploadSantanderToFreeAgent(config, tempDir, freeAgentWebdriver);
                BankSynch.addSectionToEmail(formatter, changes, "Santander", santander);
            }
            catch (Exception e) {
                BankSynch.addSectionToEmail(formatter, changes, "Santander", e.getMessage());
            }
        }
    }

    public static void addSectionToEmail(HtmlFormatter formatter, StringBuilder changes, String heading, String text) {
        changes.append(formatter.formatHeader(heading) + formatter.formatBody(text));
    }

    private static String uploadAmexToClearcheckbook(File tempDir, WebDriver webDriver, String accountName, WebDriver freeAgentWebDriver) throws Exception {
        String amexuserName = "stevel56";
        String amexpassword = "N0bigm0m";
        AmexDownloadTransactions transactions = new AmexDownloadTransactions(webDriver);
        transactions.downloadTransactions(amexuserName, amexpassword);
        String ccbuserName = "stevel56";
        String ccbpassword = "N0bigm0mas!";
        String fileToUpload = tempDir.getAbsolutePath() + "/ofx.qif";
        String amexUploads = UploadToClearCheckbook.uploadToClearCheckbook(ccbuserName, ccbpassword, accountName, fileToUpload, freeAgentWebDriver, UploadToClearCheckbook.Setting.AMEX);
        new File(fileToUpload).delete();
        return amexUploads;
    }

    private static String uploadNationwideJointToClearcheckbook(File tempDir, WebDriver webDriver, WebDriver freeAgentWebdriver, int accountIndex, String accountName, String ccbuserName, String ccbpassword) throws Exception {
        webDriver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        tempDir.delete();
        tempDir.mkdir();
        NationwideAccount.FileType type = NationwideAccount.FileType.OFX;
        new NationwideAccount(new NationwideLogin(webDriver, "2901722608", "olympia", "971659"), accountIndex, type).get();
        File[] files = tempDir.listFiles();
        if (files.length > 0) {
            String pathname = files[0].getAbsolutePath();
            System.out.println("File: " + pathname);
            String results = UploadToClearCheckbook.uploadToClearCheckbook(ccbuserName, ccbpassword, accountName, pathname, freeAgentWebdriver, UploadToClearCheckbook.Setting.NATIONWIDE);
            files[0].delete();
            return results;
        }
        return "No transactions added";
    }

    private static String uploadSantanderToFreeAgent(Config config, File tempDir, WebDriver webDriver) throws IOException {
        if (tempDir.list().length > 0) {
            String file = tempDir + "/" + tempDir.list()[0];
            System.out.println("File " + file);
            FreeAgentUploadTransactions login = new FreeAgentUploadTransactions(new FreeAgentLogin(webDriver, config));
            login.get();
            login.uploadTransactions(file);
            String transactions = FileUtils.getFileContents((String)file);
            new File(file).delete();
            return transactions;
        }
        return "No transactions added";
    }

    private BankSynch() {
    }
}

