/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.core.format;

import com.leonarduk.core.format.Formatter;
import org.apache.log4j.Logger;

public class HtmlFormatter
implements Formatter {
    static final Logger LOGGER = Logger.getLogger(HtmlFormatter.class);

    private String createNode(String value, String node) {
        return "<" + node + ">" + value + "</" + node + ">";
    }

    @Override
    public final String formatHeader(String header) {
        return this.createNode(header, "h1");
    }

    @Override
    public final String formatLink(String link, String name) {
        StringBuilder linkBuilder = new StringBuilder("<a href=\"" + link + "\">");
        linkBuilder.append(name);
        linkBuilder.append("</a>");
        return linkBuilder.toString();
    }

    @Override
    public final String formatSubHeader(String header) {
        return this.createNode(header, "h2");
    }

    @Override
    public final String getNewLine() {
        return "<br/>";
    }

    @Override
    public final String getNewSection() {
        return "<hr/>";
    }

    @Override
    public String formatBody(String text) {
        LOGGER.info((Object)("Format: " + text));
        return text.replaceAll("\n", this.getNewLine());
    }
}

