/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.core.email;

import com.leonarduk.core.email.EmailException;
import com.leonarduk.core.email.EmailSession;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class EmailSender {
    private static Logger logger = Logger.getLogger(EmailSender.class);

    public final Message createMessage(String fromEmail, String fromName, String subject, String msgBody, boolean html, EmailSession session, String ... to) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = new MimeMessage(session.getSession());
        InternetAddress[] addressTo = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            addressTo[i] = new InternetAddress(to[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        msg.setFrom((Address)new InternetAddress(fromEmail, fromName));
        msg.setSentDate(new Date());
        msg.setSubject(subject);
        if (html) {
            msg.setContent((Object)msgBody, "text/html");
        } else {
            msg.setText(msgBody);
        }
        return msg;
    }

    public final void sendMessage(String fromEmail, String fromName, String subject, String msgBody, boolean html, EmailSession session, String ... to) throws EmailException {
        try {
            logger.info((Object)("sendMessage: from " + fromEmail + " to " + to));
            Message msg = this.createMessage(fromEmail, fromName, subject, msgBody, html, session, to);
            Transport.send((Message)msg);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new EmailException("Failed to send message", (Exception)e);
        }
    }
}

