/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.core.email;

import com.leonarduk.core.email.EmailMessage;
import com.leonarduk.core.email.EmailMessageBuilder;
import com.leonarduk.core.email.EmailProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.log4j.Logger;

public class EmailReader {
    static final Logger LOGGER = Logger.getLogger(EmailReader.class);

    public final void processMail(String server, String userName, String password, ServerType serverType, String attachmentsDirectory, EmailProcessor emailProcessor) {
        Session session = null;
        Store store = null;
        Folder folder = null;
        Message[] messages = null;
        Object messagecontentObject = null;
        String sender = null;
        String subject = null;
        Multipart multipart = null;
        BodyPart part = null;
        String contentType = null;
        try {
            LOGGER.info((Object)"--------------processing mails started-----------------");
            session = Session.getDefaultInstance((Properties)System.getProperties(), null);
            LOGGER.info((Object)"getting the session for accessing email.");
            store = session.getStore(serverType.name());
            store.connect(server, userName, password);
            LOGGER.info((Object)"Connection established with IMAP server.");
            folder = store.getDefaultFolder();
            LOGGER.info((Object)"Getting the Inbox folder.");
            folder = folder.getFolder("inbox");
            folder.open(2);
            LOGGER.info((Object)"Retrieving messages.");
            messages = folder.getMessages();
            ArrayList<EmailMessage> emailList = new ArrayList<EmailMessage>();
            for (Message message : messages) {
                EmailMessageBuilder emailMessageBuilder = new EmailMessageBuilder();
                emailMessageBuilder.setSentDate(message.getSentDate());
                messagecontentObject = message.getContent();
                LOGGER.debug((Object)message.getAllHeaders());
                if (messagecontentObject instanceof Multipart) {
                    sender = ((InternetAddress)message.getFrom()[0]).getPersonal();
                    if (sender == null) {
                        sender = ((InternetAddress)message.getFrom()[0]).getAddress();
                    }
                    emailMessageBuilder.setSender(sender);
                    subject = message.getSubject();
                    emailMessageBuilder.setSubject(subject);
                    multipart = (Multipart)message.getContent();
                    for (int i = 0; i < multipart.getCount(); ++i) {
                        part = multipart.getBodyPart(i);
                        contentType = part.getContentType();
                        if (contentType.startsWith("text/plain")) {
                            emailMessageBuilder.addContent(part.getContent().toString());
                            continue;
                        }
                        String attachmentPath = attachmentsDirectory + File.separator + part.getFileName();
                        ((MimeBodyPart)part).saveFile(attachmentPath);
                        emailMessageBuilder.addFile(attachmentPath);
                    }
                } else {
                    sender = ((InternetAddress)message.getFrom()[0]).getPersonal();
                    if (sender == null) {
                        sender = ((InternetAddress)message.getFrom()[0]).getAddress();
                    }
                    emailMessageBuilder.setSender(sender);
                    subject = message.getSubject();
                    emailMessageBuilder.setSubject(subject);
                    emailMessageBuilder.addContent(messagecontentObject.toString());
                }
                EmailMessage emailMessage = emailMessageBuilder.create();
                emailProcessor.process(emailMessage);
                emailList.add(emailMessage);
            }
            folder.close(true);
            store.close();
        }
        catch (AuthenticationFailedException | FolderClosedException | FolderNotFoundException | NoSuchProviderException | ReadOnlyFolderException | StoreClosedException e) {
            LOGGER.error((Object)"Not able to process the mail reading.");
            e.printStackTrace();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Not able to process the mail reading.");
            e.printStackTrace();
        }
    }

    public static enum ServerType {
        imap,
        pop3;

    }
}

