/*
 * Decompiled with CFR 0.152.
 */
package uk.co.sleonard.accounts.web;

import com.leonarduk.web.SeleniumUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class UploadToClearCheckbook {
    public static void main(String[] args) throws Exception {
        String userName = "stevel56";
        String password = "N0bigm0mas!";
        String account = "CC - AMEX";
        String fileToUpload = "/home/stephen/Downloads/ofx(10).qif";
        WebDriver webDriver = SeleniumUtils.getDownloadCapableBrowser((String)"/home/stephen/Downloads");
        String results = UploadToClearCheckbook.uploadToClearCheckbook(userName, password, account, fileToUpload, webDriver, Setting.AMEX);
        System.out.println(results);
    }

    public static String uploadToClearCheckbook(String userName, String password, String account, String fileToUpload, WebDriver driver, Setting setting) throws Exception {
        UploadToClearCheckbook.login(userName, password, driver);
        UploadToClearCheckbook.chooseFileToUpload(fileToUpload, driver);
        switch (setting) {
            case AMEX: {
                UploadToClearCheckbook.amexSettings(account, driver);
                break;
            }
            case NATIONWIDE: {
                UploadToClearCheckbook.nationwideSettings(account, driver);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cant process " + setting.name());
            }
        }
        return UploadToClearCheckbook.importTransactions(driver);
    }

    private static void nationwideSettings(String account, WebDriver driver) {
        new Select(driver.findElement(By.id((String)"type_5"))).selectByVisibleText("Payee");
        new Select(driver.findElement(By.id((String)"type_4"))).selectByVisibleText("Description");
        new Select(driver.findElement(By.name((String)"dateFormat"))).selectByVisibleText("yyyy-mm-dd");
        new Select(driver.findElement(By.name((String)"import_to_account"))).selectByVisibleText(account);
    }

    private static String importTransactions(WebDriver driver) {
        driver.findElement(By.cssSelector((String)"button.btn.btn-primary")).click();
        driver.findElement(By.cssSelector((String)"input.btn.btn-default")).click();
        UploadToClearCheckbook.removeDuplicatesByPage(driver);
        driver.findElement(By.linkText((String)"\u00ab Return to Imported Transactions")).click();
        if (driver.findElements(By.id((String)"jive")).size() > 0) {
            driver.findElement(By.id((String)"jive")).click();
            String results = driver.findElement(By.xpath((String)"//*[@id=\"importTransactions\"]")).getText();
            driver.findElement(By.name((String)"submit[all]")).click();
            return results;
        }
        return "No transactions added";
    }

    private static void removeDuplicatesByPage(WebDriver driver) {
        String numberOfDupsXpath = "/html/body/div[2]/h3";
        Integer duplicates = Integer.valueOf(driver.findElement(By.xpath((String)numberOfDupsXpath)).getText().replace(" Duplicates Found", "").replace(" Duplicate Found", ""));
        while (duplicates > 0) {
            driver.findElement(By.id((String)"selectAllCheckbox")).click();
            driver.findElement(By.cssSelector((String)"input.btn.btn-primary")).click();
            String updateFilterXpath = "/html/body/div[2]/div[6]/form/input";
            driver.findElement(By.xpath((String)updateFilterXpath)).click();
            duplicates = Integer.valueOf(driver.findElement(By.xpath((String)numberOfDupsXpath)).getText().replace(" Duplicates Found", ""));
        }
    }

    private static void chooseFileToUpload(String fileToUpload, WebDriver driver) {
        driver.findElement(By.linkText((String)"Tools")).click();
        driver.findElement(By.linkText((String)"Import Transactions")).click();
        driver.findElement(By.id((String)"import")).sendKeys(new CharSequence[]{fileToUpload});
        driver.findElement(By.xpath((String)"//button[@type='submit']")).click();
    }

    private static void login(String userName, String password, WebDriver driver) {
        String baseUrl = "https://www.clearcheckbook.com/";
        driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
        driver.get(baseUrl + "/login");
        List userNameElement = driver.findElements(By.id((String)"ccb-l-username"));
        if (userNameElement.size() > 0) {
            ((WebElement)userNameElement.get(0)).sendKeys(new CharSequence[]{userName});
            driver.findElement(By.id((String)"ccb-l-password")).sendKeys(new CharSequence[]{password});
            driver.findElement(By.xpath((String)"//button[@type='submit']")).click();
        }
    }

    private static void amexSettings(String account, WebDriver driver) {
        new Select(driver.findElement(By.id((String)"type_4"))).selectByVisibleText("Payee");
        new Select(driver.findElement(By.name((String)"dateFormat"))).selectByVisibleText("dd/mm/yyyy");
        new Select(driver.findElement(By.name((String)"import_to_account"))).selectByVisibleText(account);
    }

    public static enum Setting {
        AMEX,
        NATIONWIDE;

    }
}

