/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.bookkeeper;

import com.leonarduk.bookkeeper.email.BFCAInvoiceProcessor;
import com.leonarduk.bookkeeper.email.VodafoneProcessor;
import com.leonarduk.core.config.Config;
import com.leonarduk.core.email.EmailProcessor;
import com.leonarduk.core.email.EmailProcessorChain;
import com.leonarduk.core.email.EmailReader;
import com.leonarduk.core.email.SimplePrintEmailProcessor;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class EmailParser {
    static final Logger LOGGER = Logger.getLogger(EmailParser.class);

    public static void main(String[] args) throws IOException {
        Config config = new Config("bookkeeper.properties");
        EmailParser.processEmails(config);
    }

    public static void processEmails(Config config) {
        String userName = config.getProperty("bookkeeper.email.user");
        String server = config.getProperty("bookkeeper.email.server");
        String serverTypeName = config.getProperty("bookkeeper.email.server.type");
        String password = config.getProperty("bookkeeper.email.password");
        EmailReader.ServerType serverType = EmailReader.ServerType.valueOf((String)serverTypeName);
        EmailReader reader = new EmailReader();
        String attachmentsFolder = config.getProperty("bookkeeper.email.attachments.savedir");
        EmailProcessorChain processor = new EmailProcessorChain();
        processor.addProcessor((EmailProcessor)new SimplePrintEmailProcessor());
        processor.addProcessor((EmailProcessor)new BFCAInvoiceProcessor());
        processor.addProcessor((EmailProcessor)new VodafoneProcessor());
        reader.processMail(server, userName, password, serverType, attachmentsFolder, (EmailProcessor)processor);
    }

    private EmailParser() {
    }
}

