/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.bookkeeper;

import com.leonarduk.bookkeeper.web.FreeAgentLogin;
import com.leonarduk.bookkeeper.web.FreeAgentUploadTransactions;
import com.leonarduk.bookkeeper.web.SantanderDownloadTransactions;
import com.leonarduk.bookkeeper.web.SantanderLogin;
import com.leonarduk.core.FileUtils;
import com.leonarduk.core.config.Config;
import com.leonarduk.core.email.EmailException;
import com.leonarduk.core.email.EmailSender;
import com.leonarduk.core.email.EmailSession;
import com.leonarduk.core.format.HtmlFormatter;
import com.leonarduk.web.SeleniumUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebDriver;
import uk.co.sleonard.accounts.web.AmexDownloadTransactions;
import uk.co.sleonard.accounts.web.NationwideAccount;
import uk.co.sleonard.accounts.web.NationwideLogin;
import uk.co.sleonard.accounts.web.UploadToClearCheckbook;

public final class BankSynch {
    static final Logger LOGGER = Logger.getLogger(BankSynch.class);

    private static void emailNotification(Config config, StringBuilder changes) throws EmailException {
        String[] toEmail = config.getArrayProperty("bookkeeper.email.to");
        String user = config.getProperty("bookkeeper.email.user");
        String server = config.getProperty("bookkeeper.email.server");
        String password = config.getProperty("bookkeeper.email.password");
        String port = config.getProperty("bookkeeper.email.port");
        EmailSender emailSender = new EmailSender();
        EmailSession session = new EmailSession(user, password, server, port);
        emailSender.sendMessage(config.getProperty("bookkeeper.email.from.email"), config.getProperty("bookkeeper.email.from.name"), "Uploaded bank transactions to Freeagent and Clearcheckbook", changes.toString(), true, session, toEmail);
    }

    private static void getSantanderTransactions(Config config, WebDriver webDriver) {
        SantanderDownloadTransactions santanderLogin = new SantanderDownloadTransactions(new SantanderLogin(webDriver, config));
        santanderLogin.get();
        santanderLogin.downloadTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config config = new Config("bookkeeper.properties");
        File tempDir = FileUtils.createTempDir();
        try (WebDriver webDriver = SeleniumUtils.getDownloadCapableBrowser((File)tempDir);){
            HtmlFormatter formatter = new HtmlFormatter();
            StringBuilder changes = new StringBuilder();
            BankSynch.processSantander(config, tempDir, webDriver, formatter, changes);
            BankSynch.processAmex(tempDir, webDriver, formatter, changes);
            BankSynch.processNationwideAccount(tempDir, webDriver, formatter, changes, "NT - Joint", 1);
            BankSynch.processNationwideAccount(tempDir, webDriver, formatter, changes, "NT Steve Current", 0);
            BankSynch.processNationwideAccount(tempDir, webDriver, formatter, changes, "NT - ISA Steve", 9);
            BankSynch.processNationwideAccount(tempDir, webDriver, formatter, changes, "NT - ISA Alex (3720 per year", 7);
            BankSynch.processNationwideAccount(tempDir, webDriver, formatter, changes, "NT Loyalty Saver", 8);
            BankSynch.emailNotification(config, changes);
        }
    }

    private static void processAmex(File tempDir, WebDriver webDriver, HtmlFormatter formatter, StringBuilder changes) throws Exception {
        String amex = "CC - AMEX";
        String amexUploads = BankSynch.uploadAmexToClearcheckbook(tempDir, webDriver, amex);
        changes.append(formatter.formatHeader(amex) + amexUploads);
        LOGGER.info((Object)(amex + amexUploads));
    }

    private static void processSantander(Config config, File tempDir, WebDriver webDriver, HtmlFormatter formatter, StringBuilder changes) throws IOException {
        BankSynch.getSantanderTransactions(config, webDriver);
        String santander = BankSynch.uploadSantanderToFreeAgent(config, tempDir, webDriver);
        changes.append(formatter.formatHeader("Santander") + santander);
        LOGGER.info((Object)("Santander: " + santander));
    }

    private static void processNationwideAccount(File tempDir, WebDriver webDriver, HtmlFormatter formatter, StringBuilder changes, String accountName, int index) throws Exception {
        changes.append(formatter.formatHeader(accountName) + BankSynch.uploadNationwideJointToClearcheckbook(tempDir, webDriver, index, accountName));
    }

    private static String uploadAmexToClearcheckbook(File tempDir, WebDriver webDriver, String accountName) throws Exception {
        String amexuserName = "stevel56";
        String amexpassword = "N0bigm0m";
        AmexDownloadTransactions transactions = new AmexDownloadTransactions(webDriver);
        transactions.downloadTransactions(amexuserName, amexpassword);
        String ccbuserName = "stevel56";
        String ccbpassword = "N0bigm0mas!";
        String fileToUpload = tempDir.getAbsolutePath() + "/ofx.qif";
        String amexUploads = UploadToClearCheckbook.uploadToClearCheckbook(ccbuserName, ccbpassword, accountName, fileToUpload, webDriver, UploadToClearCheckbook.Setting.AMEX);
        new File(fileToUpload).delete();
        return amexUploads;
    }

    private static String uploadNationwideJointToClearcheckbook(File tempDir, WebDriver webDriver, int accountIndex, String accountName) throws Exception {
        webDriver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        NationwideAccount.FileType type = NationwideAccount.FileType.OFX;
        new NationwideAccount(new NationwideLogin(webDriver, "2901722608", "olympia", "971659"), accountIndex, type).get();
        File[] files = tempDir.listFiles();
        if (files.length > 0) {
            String pathname = files[0].getAbsolutePath();
            System.out.println("File: " + pathname);
            String ccbuserName = "stevel56";
            String ccbpassword = "N0bigm0mas!";
            String results = UploadToClearCheckbook.uploadToClearCheckbook(ccbuserName, ccbpassword, accountName, pathname, webDriver, UploadToClearCheckbook.Setting.NATIONWIDE);
            files[0].delete();
            return results;
        }
        return "No transactions added";
    }

    private static String uploadSantanderToFreeAgent(Config config, File tempDir, WebDriver webDriver) throws IOException {
        if (tempDir.list().length > 0) {
            String file = tempDir + "/" + tempDir.list()[0];
            System.out.println("File " + file);
            FreeAgentUploadTransactions login = new FreeAgentUploadTransactions(new FreeAgentLogin(webDriver, config));
            login.get();
            login.uploadTransactions(file);
            String transactions = FileUtils.getFileContents((String)file);
            new File(file).delete();
            return transactions;
        }
        return "No transactions added";
    }

    private BankSynch() {
    }
}

