/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.maven.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleCreator {
    private final MavenProject project;
    private final FileFilter fileFilter;
    private final Log log;

    public BundleCreator(MavenProject project, FileFilter fileFilter, Log log) {
        this.project = project;
        this.fileFilter = fileFilter;
        this.log = log;
    }

    public IBundleCoverage createBundle(ExecutionDataStore executionDataStore) throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
        File classesDir = new File(this.project.getBuild().getOutputDirectory());
        List filesToAnalyze = FileUtils.getFiles((File)classesDir, (String)this.fileFilter.getIncludes(), (String)this.fileFilter.getExcludes());
        for (File file : filesToAnalyze) {
            analyzer.analyzeAll(file);
        }
        IBundleCoverage bundle = builder.getBundle(this.project.getName());
        this.logBundleInfo(bundle, builder.getNoMatchClasses());
        return bundle;
    }

    private void logBundleInfo(IBundleCoverage bundle, Collection<IClassCoverage> nomatch) {
        this.log.info((CharSequence)String.format("Analyzed bundle '%s' with %s classes", bundle.getName(), bundle.getClassCounter().getTotalCount()));
        if (!nomatch.isEmpty()) {
            this.log.warn((CharSequence)String.format("Classes in bundle '%s' do no match with execution data. For report generation the same class files must be used as at runtime.", bundle.getName()));
            for (IClassCoverage c : nomatch) {
                this.log.warn((CharSequence)String.format("Execution data for class %s does not match.", c.getName()));
            }
        }
    }
}

