/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.Iterator;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.webbitserver.EventSourceHandler;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.WebbitException;
import org.webbitserver.netty.EventSourceConnectionHandler;
import org.webbitserver.netty.Hixie75;
import org.webbitserver.netty.Hixie76;
import org.webbitserver.netty.Hybi;
import org.webbitserver.netty.NettyEventSourceConnection;
import org.webbitserver.netty.NettyHttpRequest;
import org.webbitserver.netty.NettyHttpResponse;
import org.webbitserver.netty.NettyWebSocketConnection;
import org.webbitserver.netty.StaleConnectionTrackingHandler;
import org.webbitserver.netty.WebSocketConnectionHandler;
import org.webbitserver.netty.WebSocketVersion;

public class NettyHttpControl
implements HttpControl {
    private final Iterator<HttpHandler> handlerIterator;
    private final Executor executor;
    private final ChannelHandlerContext ctx;
    private final NettyHttpRequest webbitHttpRequest;
    private final org.jboss.netty.handler.codec.http.HttpRequest nettyHttpRequest;
    private final org.jboss.netty.handler.codec.http.HttpResponse nettyHttpResponse;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;
    private HttpRequest defaultRequest;
    private HttpResponse webbitHttpResponse;
    private HttpControl defaultControl;
    private NettyWebSocketConnection webSocketConnection;
    private NettyEventSourceConnection eventSourceConnection;

    public NettyHttpControl(Iterator<HttpHandler> handlerIterator, Executor executor, ChannelHandlerContext ctx, NettyHttpRequest webbitHttpRequest, NettyHttpResponse webbitHttpResponse, org.jboss.netty.handler.codec.http.HttpRequest nettyHttpRequest, org.jboss.netty.handler.codec.http.HttpResponse nettyHttpResponse, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.handlerIterator = handlerIterator;
        this.executor = executor;
        this.ctx = ctx;
        this.webbitHttpRequest = webbitHttpRequest;
        this.webbitHttpResponse = webbitHttpResponse;
        this.nettyHttpRequest = nettyHttpRequest;
        this.nettyHttpResponse = nettyHttpResponse;
        this.ioExceptionHandler = ioExceptionHandler;
        this.exceptionHandler = exceptionHandler;
        this.defaultRequest = webbitHttpRequest;
        this.defaultControl = this;
    }

    @Override
    public void nextHandler() {
        this.nextHandler(this.defaultRequest, this.webbitHttpResponse, this.defaultControl);
    }

    @Override
    public void nextHandler(HttpRequest request, HttpResponse response) {
        this.nextHandler(request, response, this.defaultControl);
    }

    @Override
    public void nextHandler(HttpRequest request, HttpResponse response, HttpControl control) {
        this.defaultRequest = request;
        this.webbitHttpResponse = response;
        this.defaultControl = control;
        if (this.handlerIterator.hasNext()) {
            HttpHandler handler = this.handlerIterator.next();
            try {
                handler.handleHttpRequest(request, response, control);
            }
            catch (Throwable e) {
                response.error(e);
            }
        } else {
            response.status(404).end();
        }
    }

    @Override
    public WebSocketConnection upgradeToWebSocketConnection(WebSocketHandler webSocketHandler) {
        NettyWebSocketConnection webSocketConnection = this.webSocketConnection();
        WebSocketConnectionHandler webSocketConnectionHandler = new WebSocketConnectionHandler(this.executor, this.exceptionHandler, this.ioExceptionHandler, webSocketConnection, webSocketHandler);
        this.performWebSocketHandshake(webSocketConnection, (ChannelHandler)webSocketConnectionHandler);
        try {
            webSocketHandler.onOpen(webSocketConnection);
        }
        catch (Throwable e) {
            this.exceptionHandler.uncaughtException(Thread.currentThread(), new WebbitException(e));
        }
        return webSocketConnection;
    }

    @Override
    public NettyWebSocketConnection webSocketConnection() {
        if (this.webSocketConnection == null) {
            this.webSocketConnection = new NettyWebSocketConnection(this.executor, this.webbitHttpRequest, this.ctx, null);
        }
        return this.webSocketConnection;
    }

    @Override
    public NettyEventSourceConnection upgradeToEventSourceConnection(EventSourceHandler eventSourceHandler) {
        NettyEventSourceConnection eventSourceConnection = this.eventSourceConnection();
        EventSourceConnectionHandler eventSourceConnectionHandler = new EventSourceConnectionHandler(this.executor, this.exceptionHandler, this.ioExceptionHandler, eventSourceConnection, eventSourceHandler);
        this.performEventSourceHandshake((ChannelHandler)eventSourceConnectionHandler);
        try {
            eventSourceHandler.onOpen(eventSourceConnection);
        }
        catch (Exception e) {
            this.exceptionHandler.uncaughtException(Thread.currentThread(), new WebbitException(e));
        }
        return eventSourceConnection;
    }

    @Override
    public NettyEventSourceConnection eventSourceConnection() {
        if (this.eventSourceConnection == null) {
            this.eventSourceConnection = new NettyEventSourceConnection(this.executor, this.webbitHttpRequest, this.ctx);
        }
        return this.eventSourceConnection;
    }

    @Override
    public Executor handlerExecutor() {
        return this.executor;
    }

    @Override
    public void execute(Runnable command) {
        this.handlerExecutor().execute(command);
    }

    private void performEventSourceHandshake(ChannelHandler eventSourceConnectionHandler) {
        this.nettyHttpResponse.setStatus(HttpResponseStatus.OK);
        this.nettyHttpResponse.addHeader("Content-Type", (Object)"text/event-stream");
        this.nettyHttpResponse.addHeader("Transfer-Encoding", (Object)"identity");
        this.nettyHttpResponse.addHeader("Connection", (Object)"keep-alive");
        this.nettyHttpResponse.addHeader("Cache-Control", (Object)"no-cache");
        this.nettyHttpResponse.setChunked(false);
        this.ctx.getChannel().write((Object)this.nettyHttpResponse);
        this.getReadyToSendEventSourceMessages(eventSourceConnectionHandler);
    }

    private void getReadyToSendEventSourceMessages(ChannelHandler eventSourceConnectionHandler) {
        ChannelPipeline p = this.ctx.getChannel().getPipeline();
        StaleConnectionTrackingHandler staleConnectionTracker = (StaleConnectionTrackingHandler)p.remove("staleconnectiontracker");
        staleConnectionTracker.stopTracking(this.ctx.getChannel());
        p.remove("aggregator");
        p.replace("handler", "ssehandler", eventSourceConnectionHandler);
    }

    private void performWebSocketHandshake(NettyWebSocketConnection webSocketConnection, ChannelHandler webSocketConnectionHandler) {
        WebSocketVersion[] versions = new WebSocketVersion[]{new Hybi(this.nettyHttpRequest, this.nettyHttpResponse), new Hixie76(this.nettyHttpRequest, this.nettyHttpResponse), new Hixie75(this.nettyHttpRequest, this.nettyHttpResponse)};
        Channel channel = this.ctx.getChannel();
        ChannelPipeline pipeline = channel.getPipeline();
        for (WebSocketVersion webSocketVersion : versions) {
            if (!webSocketVersion.matches()) continue;
            ChannelHandler webSocketFrameDecoder = webSocketVersion.createDecoder();
            this.getReadyToReceiveWebSocketMessages(webSocketFrameDecoder, webSocketConnectionHandler, pipeline, channel);
            webSocketVersion.prepareHandshakeResponse(webSocketConnection);
            channel.write((Object)this.nettyHttpResponse);
            this.getReadyToSendWebSocketMessages(webSocketVersion.createEncoder(), pipeline);
            break;
        }
    }

    private void getReadyToReceiveWebSocketMessages(ChannelHandler webSocketFrameDecoder, ChannelHandler webSocketConnectionHandler, ChannelPipeline p, Channel channel) {
        StaleConnectionTrackingHandler staleConnectionTracker = (StaleConnectionTrackingHandler)p.remove("staleconnectiontracker");
        staleConnectionTracker.stopTracking(channel);
        p.remove("aggregator");
        p.replace("decoder", "wsdecoder", webSocketFrameDecoder);
        p.replace("handler", "wshandler", webSocketConnectionHandler);
    }

    private void getReadyToSendWebSocketMessages(ChannelHandler webSocketFrameEncoder, ChannelPipeline p) {
        p.replace("encoder", "wsencoder", webSocketFrameEncoder);
    }
}

