/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.bookkeeper;

import com.leonarduk.bookkeeper.web.FreeAgentLogin;
import com.leonarduk.bookkeeper.web.FreeAgentUploadTransactions;
import com.leonarduk.bookkeeper.web.SantanderDownloadTransactions;
import com.leonarduk.bookkeeper.web.SantanderLogin;
import com.leonarduk.core.FileUtils;
import com.leonarduk.core.config.Config;
import com.leonarduk.core.email.EmailException;
import com.leonarduk.core.email.EmailSender;
import com.leonarduk.core.email.EmailSession;
import com.leonarduk.web.SeleniumUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebDriver;
import uk.co.sleonard.accounts.web.AmexDownloadTransactions;
import uk.co.sleonard.accounts.web.UploadToClearCheckbook;

public final class BankSynch {
    static final Logger LOGGER = Logger.getLogger(BankSynch.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config config = new Config("bookkeeper.properties");
        File tempDir = FileUtils.createTempDir();
        try (WebDriver webDriver = SeleniumUtils.getDownloadCapableBrowser((File)tempDir);){
            BankSynch.getSantanderTransactions(config, webDriver);
            StringBuilder changes = new StringBuilder(BankSynch.uploadSantanderToFreeAgent(config, tempDir, webDriver));
            LOGGER.info((Object)("Santander: " + changes));
            String amexUploads = BankSynch.uploadAmexToClearcheckbook(tempDir, webDriver);
            changes.append("\nAMEX:\n" + amexUploads);
            LOGGER.info((Object)("AMEX: " + amexUploads));
            BankSynch.emailNotification(config, changes);
        }
    }

    private static void emailNotification(Config config, StringBuilder changes) throws EmailException {
        String[] toEmail = config.getArrayProperty("bookkeeper.email.to");
        String user = config.getProperty("bookkeeper.email.user");
        String server = config.getProperty("bookkeeper.email.server");
        String password = config.getProperty("bookkeeper.email.password");
        String port = config.getProperty("bookkeeper.email.port");
        EmailSender emailSender = new EmailSender();
        EmailSession session = new EmailSession(user, password, server, port);
        emailSender.sendMessage(config.getProperty("bookkeeper.email.from.email"), config.getProperty("bookkeeper.email.from.name"), "Uploaded bank transactions to Freeagent and Clearcheckbook", changes.toString(), true, session, toEmail);
    }

    private static String uploadAmexToClearcheckbook(File tempDir, WebDriver webDriver) throws Exception {
        String amexuserName = "stevel56";
        String amexpassword = "N0bigm0m";
        AmexDownloadTransactions transactions = new AmexDownloadTransactions(webDriver);
        transactions.downloadTransactions(amexuserName, amexpassword);
        String ccbuserName = "stevel56";
        String ccbpassword = "N0bigm0mas!";
        String account = "CC - AMEX";
        String fileToUpload = tempDir.getAbsolutePath() + "/ofx.qif";
        String amexUploads = UploadToClearCheckbook.uploadToClearCheckbook(ccbuserName, ccbpassword, account, fileToUpload, webDriver);
        return amexUploads;
    }

    private static String uploadSantanderToFreeAgent(Config config, File tempDir, WebDriver webDriver) throws IOException {
        if (tempDir.list().length > 0) {
            String file = tempDir + "/" + tempDir.list()[0];
            System.out.println("File " + file);
            FreeAgentUploadTransactions login = new FreeAgentUploadTransactions(new FreeAgentLogin(webDriver, config));
            login.get();
            login.uploadTransactions(file);
            return "Santander:\n" + FileUtils.getFileContents((String)file);
        }
        return "";
    }

    private static void getSantanderTransactions(Config config, WebDriver webDriver) {
        SantanderDownloadTransactions santanderLogin = new SantanderDownloadTransactions(new SantanderLogin(webDriver, config));
        santanderLogin.get();
        santanderLogin.downloadTransactions();
    }

    private BankSynch() {
    }
}

