/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.bookkeeper.web;

import com.leonarduk.core.config.Config;
import com.leonarduk.web.BaseSeleniumPage;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SantanderLogin
extends BaseSeleniumPage {
    public static final String PASSWORD_SUBMIT_XPATH = "//*[@id=\"formAuthenticationAbbey\"]/div[2]/span[1]/input";
    public static final String PASSWORD_VALUE_XPATH = "//*[@id=\"passwordPosition";
    public static final String SIGN_POSITION_PREFIX = "signPosition";
    public static final String ANSWER_SUBMIT_XPATH = "//*[@id=\"formCustomerID\"]/div/span[1]/input";
    public static final String CUSTOMER_ID_SUBMIT_XPATH = "//*[@id=\"formCustomerID_1\"]/fieldset/div/div/span/input";
    public static final String CUSTOMER_ID_XPATH = "//*[@id=\"infoLDAP_E.customerID\"]";
    public static final String ANSWER_XPATH = "//*[@id=\"cbQuestionChallenge.responseUser\"]";
    private static final String IN_WHAT_CITY_OR_TOWN_WERE_YOU_MARRIED = "In what city or town were you married? (Enter full name of city or town)";
    public static final String IN_WHAT_CITY_OR_TOWN_WERE_YOU_BORN = "In what city or town were you born? (Enter full name of city or town only)";
    private static final String IN_WHAT_CITY_OR_TOWN_WAS_YOUR_FATHER_BORN = "In what city or town was your father born? (Enter full name of city or town only)";
    public static final String WHAT_IS_YOUR_FATHER_S_MIDDLE_NAME = "What is your father\u00b4s middle name?";
    public static final String WHAT_WAS_THE_NAME_OF_YOUR_FIRST_PET = "What was the name of your first pet?";
    public static final String NAME_OF_YOUR_LAST_SCHOOL = "What was the name of your last school? (Enter only \"Thingwall\" for Thingwall infant School)";
    public static final String WHAT_IS_YOUR_FAVOURITE_FOOTBALL_TEAM = "What is your favourite football team?";
    public static final String WHERE_DID_YOU_MEET_YOUR_SPOUSE = "Where did you meet your spouse for the first time? (Enter full name of city or town only)";
    public static final String NAME_OF_CHIEF_BRIDESMAID = "What is the first name of the maid of honour or chief bridesmaid at your wedding?";
    public static final String QUESTION_XPATH = "//*[@id=\"formCustomerID\"]/fieldset/div/div[1]/span[2]";
    static final Logger LOGGER = Logger.getLogger(SantanderLogin.class);
    private static final String SECURITY_ID_POSITION_PREFIX = "passwordPosition";
    private static final String SECURITY_ID_INDEX_PREFIX = "//*[@id=\"formAuthenticationAbbey\"]/div[1]/div[2]/span[2]/span/span[1]/label[";
    public static final String PASSWORD_INDEX_XPATH = "//*[@id=\"formAuthenticationAbbey\"]/div[1]/div[1]/span[2]/span/span[1]/label[";
    private final String accountsUrl;
    private final String customerId;
    private final Question[] filterQuestions = new Question[]{new Question("bridesmaid", "What is the first name of the maid of honour or chief bridesmaid at your wedding?"), new Question("football", "What is your favourite football team?"), new Question("spouse", "Where did you meet your spouse for the first time? (Enter full name of city or town only)"), new Question("school", "What was the name of your last school? (Enter only \"Thingwall\" for Thingwall infant School)"), new Question("pet", "What was the name of your first pet?"), new Question("fathermiddle", "What is your father\u00b4s middle name?"), new Question("fatherborn", "In what city or town was your father born? (Enter full name of city or town only)"), new Question("born", "In what city or town were you born? (Enter full name of city or town only)"), new Question("citymarried", "In what city or town were you married? (Enter full name of city or town)")};
    private final String loginUrl;
    private final String password;
    private final Map<String, String> questions;
    private final String securityNumber;

    public SantanderLogin(WebDriver webDriver, Config config) {
        super(webDriver);
        this.loginUrl = config.getProperty("bookkeeper.web.santander.url.start");
        this.accountsUrl = config.getProperty("bookkeeper.web.santander.url.accounts");
        this.customerId = config.getProperty("bookkeeper.web.santander.id");
        this.password = config.getProperty("bookkeeper.web.santander.password");
        this.securityNumber = config.getProperty("bookkeeper.web.santander.securitynumber");
        this.questions = new HashMap<String, String>();
        String questionPrefix = "bookkeeper.web.santander.question.";
        for (Question question : this.filterQuestions) {
            this.questions.put(question.configKeyString, config.getProperty("bookkeeper.web.santander.question." + question.configKeyString));
            LOGGER.info((Object)("Q: " + question.configKeyString + " - " + this.questions.get(question.configKeyString)));
        }
        LOGGER.info((Object)("URL: " + this.loginUrl));
        LOGGER.info((Object)("ID: " + this.customerId));
        LOGGER.info((Object)("Password: " + this.password));
        LOGGER.info((Object)("SecurityNumber: " + this.securityNumber));
    }

    private void enterCustomerId() {
        this.enterValueIntoField(this.customerId, CUSTOMER_ID_XPATH);
        this.clickField(CUSTOMER_ID_SUBMIT_XPATH);
    }

    private void enterCode(int index, WebElement webElement, String prefix, String keyphrase) {
        String xpath = prefix + index + "]";
        String text = this.findElementByXpath(xpath).getText();
        int value = this.keepNumberOnly(text);
        String character = keyphrase.substring(value - 1, value);
        LOGGER.info((Object)(text + " " + value + " " + character));
        webElement.sendKeys(new CharSequence[]{character});
    }

    private void filterQuestion() {
        String questionText = this.getWebDriver().findElement(By.xpath((String)QUESTION_XPATH)).getText();
        String answer = null;
        for (Question question : this.filterQuestions) {
            if (!questionText.equals(question.questionTextString)) continue;
            answer = this.questions.get(question.configKeyString);
            break;
        }
        if (null == answer) {
            throw new RuntimeException("Unexpected question:" + questionText);
        }
        this.enterValueIntoField(answer, ANSWER_XPATH);
        this.clickField(ANSWER_SUBMIT_XPATH);
    }

    protected final String getAccountsUrl() {
        return this.accountsUrl;
    }

    protected final void isLoaded() {
        if (!this.getWebDriver().getCurrentUrl().startsWith(this.accountsUrl)) {
            this.load();
        }
        if (!this.getWebDriver().getCurrentUrl().startsWith(this.accountsUrl)) {
            throw new RuntimeException(this.accountsUrl + " is  not loaded. Instead is " + this.getWebDriver().getCurrentUrl());
        }
    }

    protected final void load() {
        this.getWebDriver().get(this.loginUrl);
        this.waitForPageToLoad();
        this.enterCustomerId();
        this.waitForPageToLoad();
        try {
            this.filterQuestion();
            this.waitForPageToLoad();
        }
        catch (NoSuchElementException e) {
            LOGGER.info((Object)"No filter screen. Ignore and try next page");
        }
        this.passwordPage();
        WebElement popup = this.findElementByXpath("//*[@id=\"PopUp\"]/div/form/fieldset/div/span/a");
        if (null != popup) {
            popup.click();
        }
        this.waitForPageToLoad();
    }

    private void passwordPage() {
        this.enterPassword();
        this.enterSecurityNumber();
        this.clickField(PASSWORD_SUBMIT_XPATH);
    }

    private void enterSecurityNumber() {
        String signPositionPrefix = SECURITY_ID_POSITION_PREFIX;
        String prefix = SECURITY_ID_INDEX_PREFIX;
        this.enterCharacters(signPositionPrefix, prefix, this.securityNumber);
    }

    private void enterPassword() {
        String signPositionPrefix = SIGN_POSITION_PREFIX;
        String prefix = PASSWORD_INDEX_XPATH;
        this.enterCharacters(signPositionPrefix, prefix, this.password);
    }

    private void enterCharacters(String signPositionPrefix, String prefix, String keyword) {
        int numberOfDigits = 3;
        WebElement[] nodes = new WebElement[3];
        for (int i = 1; i < 4; ++i) {
            WebElement node = this.getWebDriver().findElement(By.name((String)(signPositionPrefix + i)));
            int index = Integer.valueOf(node.getAttribute("tabindex")) - 1;
            if (index >= 3) {
                index -= 3;
            }
            nodes[index] = node;
        }
        this.enterCode(1, nodes[0], prefix, keyword);
        this.enterCode(2, nodes[1], prefix, keyword);
        this.enterCode(3, nodes[2], prefix, keyword);
    }

    class Question {
        private final String configKeyString;
        private final String questionTextString;

        public Question(String configKey, String questionText) {
            this.configKeyString = configKey;
            this.questionTextString = questionText;
        }
    }
}

