/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectResolver;
import org.hibernate.exception.JDBCConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectResolverSet
implements DialectResolver {
    private static Logger log = LoggerFactory.getLogger(DialectResolverSet.class);
    private List resolvers = new ArrayList();

    public Dialect resolveDialect(DatabaseMetaData metaData) {
        for (DialectResolver resolver : this.resolvers) {
            try {
                Dialect dialect = resolver.resolveDialect(metaData);
                if (dialect == null) continue;
                return dialect;
            }
            catch (JDBCConnectionException e) {
                throw e;
            }
            catch (Throwable t) {
                log.info("sub-resolver threw unexpected exception, continuing to next : " + t.getMessage());
            }
        }
        return null;
    }

    public void addResolver(DialectResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void addResolverAtFirst(DialectResolver resolver) {
        this.resolvers.add(0, resolver);
    }
}

