/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;

public final class FileUtils {
    public static final String CARRIAGE_RETURN = "\n";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static File createTempDir() throws IOException {
        return FileUtils.createTempDir(System.getProperty("java.io.tmpdir"));
    }

    public static File createTempDir(String baseDir) throws IOException {
        int lengthOfNumber = 6;
        String tmpDirPath = baseDir + FILE_SEPARATOR + RandomStringUtils.randomAlphanumeric((int)6);
        File tempDir = new File(tmpDirPath);
        boolean tmpDirCreated = tempDir.mkdir();
        if (!tmpDirCreated) {
            throw new IOException("Failed to create " + tmpDirPath);
        }
        return tempDir;
    }

    public static String getFileContents(String filename) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        FileReader in = new FileReader(filename);
        BufferedReader br = new BufferedReader(in);
        while ((line = br.readLine()) != null) {
            buf.append(line);
            buf.append(CARRIAGE_RETURN);
        }
        in.close();
        return buf.toString().trim();
    }

    public static void writeStringToFile(String fileName, String contents) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            String[] lines;
            for (String line : lines = contents.split(CARRIAGE_RETURN)) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException();
    }
}

