/*
 * Decompiled with CFR 0.152.
 */
package com.adamshone.freecycle.impl;

import com.adamshone.freecycle.Post;
import com.adamshone.freecycle.PostReceiver;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

public class TwitterPostReceiver
implements PostReceiver {
    Logger log = Logger.getLogger(TwitterPostReceiver.class);
    private final String twitterScreenName;
    private final Twitter twitter;
    private Status mostRecentStatus;

    TwitterPostReceiver(Twitter twitter, String twitterScreenName) {
        this.log.info((Object)String.format("Instantiated with twitterScreenName=%s", twitterScreenName));
        this.twitterScreenName = twitterScreenName;
        this.twitter = twitter;
    }

    public TwitterPostReceiver(TwitterFactory twitterFactory, String twitterScreenName) {
        this(twitterFactory.getInstance(), twitterScreenName);
    }

    @Override
    public void receivePosts(List<Post> posts) {
        this.log.info((Object)String.format("Received %s posts", posts.size()));
        try {
            this.setMostRecentStatus();
            this.tweetAllNewPostsFrom(posts);
        }
        catch (TwitterException e) {
            this.log.error((Object)"Unable to set most recent status", (Throwable)e);
        }
    }

    private void setMostRecentStatus() throws TwitterException {
        this.log.info((Object)String.format("Retrieving most recent status for %s", this.twitterScreenName));
        this.mostRecentStatus = (Status)this.twitter.getUserTimeline(this.twitterScreenName).get(0);
        this.log.info((Object)String.format("Text of most recent status=\"%s\"", this.mostRecentStatus.getText()));
        this.log.info((Object)String.format("Date of most recent status: %s", this.mostRecentStatus.getCreatedAt()));
    }

    private void tweetAllNewPostsFrom(List<Post> posts) {
        int postsTweetedSuccessfully = 0;
        int postsNotTweeted = 0;
        for (Post post : posts) {
            try {
                if (this.isNew(post)) {
                    String newStatus = post.toPost();
                    this.twitter.updateStatus(newStatus);
                    this.log.info((Object)String.format("Tweeted: %s", newStatus));
                    ++postsTweetedSuccessfully;
                    continue;
                }
                ++postsNotTweeted;
            }
            catch (TwitterException e) {
                this.log.error((Object)String.format("Unable to send tweet: \"%s\"", post.toPost()), (Throwable)e);
            }
        }
        String postString = postsTweetedSuccessfully > 0 ? String.valueOf(postsTweetedSuccessfully) : "no";
        this.log.info((Object)String.format("Tweeted %s new posts to the %s feed, did not tweet %s posts", postString, this.twitterScreenName, postsNotTweeted));
    }

    private boolean isNew(Post post) {
        boolean isNewer;
        Date statusTime = this.mostRecentStatus.getCreatedAt();
        Date postTime = post.getDate();
        boolean bl = isNewer = postTime.compareTo(statusTime) > 0;
        if (!isNewer) {
            this.log.debug((Object)String.format("Post is older than most recent status (%s older than %s): \"%s\"", postTime, statusTime, post.getText()));
        }
        return isNewer;
    }
}

