/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Arrays;
import twitter4j.HttpResponse;
import twitter4j.IDs;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;

final class IDsJSONImpl
extends TwitterResponseImpl
implements IDs {
    private static final long serialVersionUID = 6999637496007165672L;
    private long[] ids;
    private long previousCursor = -1L;
    private long nextCursor = -1L;

    IDsJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        String json = res.asString();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    IDsJSONImpl(String json) throws TwitterException {
        this.init(json);
    }

    private void init(String jsonStr) throws TwitterException {
        try {
            if (jsonStr.startsWith("{")) {
                JSONObject json = new JSONObject(jsonStr);
                JSONArray idList = json.getJSONArray("ids");
                this.ids = new long[idList.length()];
                for (int i = 0; i < idList.length(); ++i) {
                    try {
                        this.ids[i] = Long.parseLong(idList.getString(i));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TwitterException("Twitter API returned malformed response: " + json, nfe);
                    }
                }
                this.previousCursor = ParseUtil.getLong("previous_cursor", json);
                this.nextCursor = ParseUtil.getLong("next_cursor", json);
            } else {
                JSONArray idList = new JSONArray(jsonStr);
                this.ids = new long[idList.length()];
                for (int i = 0; i < idList.length(); ++i) {
                    try {
                        this.ids[i] = Long.parseLong(idList.getString(i));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TwitterException("Twitter API returned malformed response: " + idList, nfe);
                    }
                }
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public long[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.getIDs());
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDsJSONImpl{ids=" + Arrays.toString(this.ids) + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

