/*
 * Decompiled with CFR 0.152.
 */
package com.adamshone.freecycle.impl;

import com.adamshone.freecycle.Post;
import com.adamshone.freecycle.PostProvider;
import com.adamshone.freecycle.PostType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasChildFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;

public class FreecycleNewhamScraper
implements PostProvider {
    Logger log = Logger.getLogger(FreecycleNewhamScraper.class);
    private static final NodeFilter tableDataContainingLinkFilter = new AndFilter(new TagNameFilter("td"), new HasChildFilter(new TagNameFilter("a")));
    private final Parser parser;
    private final SimpleDateFormat freecycleDateFormat;
    private final List<Post> posts = new ArrayList<Post>();

    public FreecycleNewhamScraper(Parser parser, String dateFormat) {
        this.log.info((Object)String.format("Instantiated with url=%s, dateFormat=%s", parser.getURL(), dateFormat));
        this.parser = parser;
        this.freecycleDateFormat = new SimpleDateFormat(dateFormat);
    }

    protected Parser getParser() {
        return this.parser;
    }

    @Override
    public List<Post> getPosts() {
        this.log.info((Object)String.format("Fetching posts", new Object[0]));
        this.posts.clear();
        try {
            NodeList list = this.getHTMLNodes();
            this.log.info((Object)String.format("Parsed %s matching HTML nodes", list.size()));
            SimpleNodeIterator iterator = list.elements();
            while (iterator.hasMoreNodes()) {
                try {
                    Post post = this.parsePostFromHTMLNodes(iterator);
                    this.posts.add(0, post);
                }
                catch (ParseException e) {
                    this.log.error((Object)"Unable to parse HTML node into a post", (Throwable)e);
                }
            }
        }
        catch (ParserException e) {
            this.log.error((Object)"Unable to retrieve HTML nodes", (Throwable)e);
        }
        this.log.info((Object)String.format("Returning %s posts", this.posts.size()));
        return this.posts;
    }

    private NodeList getHTMLNodes() throws ParserException {
        this.log.info((Object)"Extracting HTML nodes");
        this.parser.setURL(this.parser.getURL());
        return this.parser.extractAllNodesThatMatch(tableDataContainingLinkFilter);
    }

    private Post parsePostFromHTMLNodes(SimpleNodeIterator iterator) throws ParseException {
        Node typeAndDateNode = iterator.nextNode();
        PostType postType = PostType.parse(typeAndDateNode);
        Date postDate = FreecycleNewhamScraper.parseDateFrom(typeAndDateNode, this.freecycleDateFormat);
        Node linkAndDescriptionNode = iterator.nextNode();
        String description = linkAndDescriptionNode.getChildren().elementAt(1).toPlainTextString();
        String link = ((TagNode)linkAndDescriptionNode.getChildren().elementAt(1)).getAttribute("href");
        return new Post(postType, postDate, description, link);
    }

    private static Date parseDateFrom(Node typeAndDateNode, SimpleDateFormat dateFormat) throws ParseException {
        Node dateNode = typeAndDateNode.getChildren().elementAt(4);
        String dateString = dateNode.toPlainTextString().trim();
        Date date = dateFormat.parse(dateString);
        return date;
    }
}

