/*
 * Decompiled with CFR 0.152.
 */
package com.adamshone.freecycle;

import com.adamshone.freecycle.PostType;
import java.util.Date;

public class Post {
    private final String link;
    private final Date postDate;
    private final PostType postType;
    private final String title;

    public Post(Post post) {
        this(post.postType, post.postDate, post.title, post.link);
    }

    public Post(PostType postType, Date postDate, String title, String link) {
        this.postType = postType;
        this.postDate = postDate;
        this.title = title;
        this.link = link;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Post other = (Post)obj;
        if (this.link == null ? other.link != null : !this.link.equals(other.link)) {
            return false;
        }
        if (this.postDate == null ? other.postDate != null : !this.postDate.equals(other.postDate)) {
            return false;
        }
        if (this.postType != other.postType) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public Date getDate() {
        return this.postDate;
    }

    public String getLink() {
        return this.link;
    }

    public PostType getPostType() {
        return this.postType;
    }

    public String getText() {
        return this.title;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.link == null ? 0 : this.link.hashCode());
        result = 31 * result + (this.postDate == null ? 0 : this.postDate.hashCode());
        result = 31 * result + (this.postType == null ? 0 : this.postType.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public String toPost() {
        return String.format("%s: %s (%s)", new Object[]{this.postType, this.title, this.link});
    }

    public String toString() {
        return String.format("%s: %s: %s (%s)", new Object[]{this.postDate, this.postType, this.title, this.link});
    }
}

