/*
 * Decompiled with CFR 0.152.
 */
package com.adamshone.freecycle;

import com.adamshone.freecycle.Post;
import com.adamshone.freecycle.PostProvider;
import com.adamshone.freecycle.PostReceiver;
import java.util.List;
import org.apache.log4j.Logger;

public class FreecycleFeed {
    private static final Logger log = Logger.getLogger(FreecycleFeed.class);
    private final PostProvider postProvider;
    private final PostReceiver postReceiver;
    private final long timeBetweenUpdates;
    private final int maxUpdates;
    private int updatesMade = 0;

    public FreecycleFeed(PostProvider postProvider, PostReceiver postReceiver, String timeBetweenUpdates, String maxUpdates) {
        log.info((Object)String.format("Instantiated with timeBetweenUpdates=%s, maxUpdates=%s", timeBetweenUpdates, maxUpdates));
        this.postProvider = postProvider;
        this.postReceiver = postReceiver;
        this.timeBetweenUpdates = Long.parseLong(timeBetweenUpdates);
        this.maxUpdates = Integer.parseInt(maxUpdates);
    }

    public FreecycleFeed(PostProvider postProvider, PostReceiver postReceiver, String timeBetweenUpdates) {
        this(postProvider, postReceiver, timeBetweenUpdates, "-1");
    }

    public void start() {
        log.info((Object)"FreecycleFeed starting");
        while (this.updatesMade < this.maxUpdates || this.maxUpdates == -1) {
            log.info((Object)"Woken up");
            List<Post> posts = this.postProvider.getPosts();
            this.postReceiver.receivePosts(posts);
            ++this.updatesMade;
            log.info((Object)String.format("Made %s checks since startup, sleeping for %sms", this.updatesMade, this.timeBetweenUpdates));
            try {
                Thread.sleep(this.timeBetweenUpdates);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        log.info((Object)String.format("FreecycleFeed terminated after %s updates", this.updatesMade));
    }
}

