/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public final class SeleniumUtils {
    public static WebDriver getDownloadCapableBrowser(File tempDir) throws IOException {
        return SeleniumUtils.getDownloadCapableBrowser(tempDir, false);
    }

    public static WebDriver getDownloadCapableBrowser(File tempDir, boolean runInBackground) throws IOException {
        if (!tempDir.exists()) {
            throw new FileNotFoundException("Directory " + tempDir + " does not exist");
        }
        FirefoxProfile fp = new FirefoxProfile();
        fp.setPreference("browser.download.folderList", 2);
        fp.setPreference("browser.download.manager.showWhenStarting", false);
        fp.setPreference("browser.download.dir", tempDir.getCanonicalPath());
        fp.setPreference("browser.helperApps.alwaysAsk.force", false);
        fp.setPreference("browser.helperApps.neverAsk.saveToDisk", "application/x-csv,text/html,text/ofx,application/ofx,application/x-ofx,application/x-qif,text/csv,text/x-csv,application/x-download,application/vnd.ms-excel,application/pdf,text/plain");
        fp.setPreference("browser.helperApps.neverAsk.openFile", "application/x-csv,text/html,text/ofx,application/ofx,application/octet-stream,application/x-ofx,application/vnd.ms-excel,text/csv,text/x-csv,application/x-download,application/vnd.ms-excel,application/pdf,text/plain");
        if (runInBackground) {
            String xport = System.getProperty("Importal.xvfb.id", ":1");
            FirefoxBinary firefoxBinary = new FirefoxBinary();
            firefoxBinary.setEnvironmentProperty("DISPLAY", xport);
            return new FirefoxDriver(firefoxBinary, fp);
        }
        return new FirefoxDriver(fp);
    }

    public static WebDriver getDownloadCapableBrowser(String downloadDir) throws IOException {
        return SeleniumUtils.getDownloadCapableBrowser(downloadDir, false);
    }

    public static WebDriver getDownloadCapableBrowser(String downloadDir, boolean runInBackground) throws IOException {
        File tempDir = new File(downloadDir);
        return SeleniumUtils.getDownloadCapableBrowser(tempDir, runInBackground);
    }

    private SeleniumUtils() {
        throw new UnsupportedOperationException();
    }
}

