/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.core.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Config {
    private final Properties props = new Properties();

    public Config() {
    }

    public Config(String propFileName) throws IOException {
        this();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        this.props.load(inputStream);
    }

    public final String[] getArrayProperty(String fieldName) {
        String value = this.getProperty(fieldName);
        if (null == value) {
            return null;
        }
        return value.replaceAll("\"", "").split("\\s*,\\s*");
    }

    public final boolean getBooleanProperty(String fieldName) {
        String value = this.getProperty(fieldName);
        if (null == value) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public final Double getDoubleProperty(String fieldName) {
        String value = this.getProperty(fieldName);
        if (null == value) {
            return null;
        }
        return Double.valueOf(value);
    }

    public final Integer getIntegerProperty(String fieldName) {
        String value = this.getProperty(fieldName);
        if (null == value) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public final String getProperty(String fieldName) {
        return this.props.getProperty(fieldName);
    }

    public final void setProperty(String fieldName, String value) {
        this.props.setProperty(fieldName, value);
    }
}

