/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.web;

import org.apache.log4j.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.LoadableComponent;

public abstract class BaseSeleniumPage
extends LoadableComponent<BaseSeleniumPage> {
    private final WebDriver webdriver;
    private final String expectedUrl;
    private boolean acceptNextAlert = true;
    public static final int ONE_SECOND_IN_MS = 1000;
    static final Logger LOGGER = Logger.getLogger(BaseSeleniumPage.class);

    public BaseSeleniumPage(WebDriver webDriver, String expectedUrl) {
        this.expectedUrl = expectedUrl;
        this.webdriver = webDriver;
    }

    public final String getExpectedUrl() {
        return this.expectedUrl;
    }

    protected final void clickField(String xpath) {
        this.findElementByXpath(xpath).click();
    }

    protected final WebElement enterValueIntoField(String answer, String xpath) {
        WebElement element = this.findElementByXpath(xpath);
        element.clear();
        element.sendKeys(new CharSequence[]{answer});
        return element;
    }

    protected final WebElement findElementByXpath(String xpath) {
        WebElement findElement = this.webdriver.findElement(By.xpath((String)xpath));
        if (null == findElement) {
            throw new NoSuchElementException("Could not find xpath " + xpath);
        }
        return findElement;
    }

    public final WebDriver getWebDriver() {
        return this.webdriver;
    }

    protected final int keepNumberOnly(String password2) {
        return Integer.valueOf(password2.replaceAll("\\D+", ""));
    }

    public boolean isElementPresent(By by) {
        try {
            this.getWebDriver().findElement(by);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isAlertPresent() {
        try {
            this.getWebDriver().switchTo().alert();
            return true;
        }
        catch (NoAlertPresentException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String closeAlertAndGetItsText() {
        try {
            Alert alert = this.getWebDriver().switchTo().alert();
            String alertText = alert.getText();
            if (this.acceptNextAlert) {
                alert.accept();
            } else {
                alert.dismiss();
            }
            String string = alertText;
            return string;
        }
        finally {
            this.acceptNextAlert = true;
        }
    }

    protected final void waitForPageToLoad() {
        try {
            int halfASecond = 500;
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            LOGGER.info((Object)"Interrupted");
        }
    }

    protected final void isLoaded() {
        String url;
        if (!this.getWebDriver().getCurrentUrl().equals(this.expectedUrl)) {
            this.load();
        }
        if (!(url = this.getWebDriver().getCurrentUrl()).startsWith(this.expectedUrl)) {
            throw new RuntimeException(this.expectedUrl + " is  not loaded. Instead is " + url);
        }
    }
}

