/*
 * Decompiled with CFR 0.152.
 */
package com.leonarduk.core.email;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class EmailSession {
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_STMP_USER = "mail.stmp.user";
    private final Session session;

    public EmailSession(String user, String password, String server, String port) {
        this.session = this.createSession(user, password, server, port);
    }

    public final Session createSession(String user, String password, String server, String port) {
        Properties props = new Properties();
        props.put(MAIL_SMTP_HOST, server);
        props.put(MAIL_SMTP_SOCKET_FACTORY_PORT, port);
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put(MAIL_STMP_USER, user);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put(MAIL_SMTP_PASSWORD, password);
        Session localSession = Session.getDefaultInstance((Properties)props, (Authenticator)this.getAuthenticator(user, password));
        return localSession;
    }

    public final Authenticator getAuthenticator(final String userName, final String password) {
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        };
        return auth;
    }

    public final Session getSession() {
        return this.session;
    }
}

